/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public interface UnionTypeHandlerPlugin {
    public ClassName className(UnionPluginContext var1, UnionTypeDeclaration var2, ClassName var3, EventType var4);

    public TypeSpec.Builder classCreated(UnionPluginContext var1, UnionTypeDeclaration var2, TypeSpec.Builder var3, EventType var4);

    public FieldSpec.Builder anyFieldCreated(UnionPluginContext var1, UnionTypeDeclaration var2, TypeSpec.Builder var3, FieldSpec.Builder var4, EventType var5);

    public FieldSpec.Builder fieldBuilt(UnionPluginContext var1, TypeDeclaration var2, FieldSpec.Builder var3, EventType var4);

    public static class Composite
    implements UnionTypeHandlerPlugin {
        private final List<UnionTypeHandlerPlugin> plugins = new ArrayList<UnionTypeHandlerPlugin>();

        public Composite(Set<UnionTypeHandlerPlugin> actualPlugins) {
            this.plugins.addAll(actualPlugins);
        }

        @Override
        public ClassName className(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
            for (UnionTypeHandlerPlugin plugin : this.plugins) {
                currentSuggestion = plugin.className(unionPluginContext, ramlType, currentSuggestion, eventType);
            }
            return currentSuggestion;
        }

        @Override
        public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
            for (UnionTypeHandlerPlugin plugin : this.plugins) {
                if (incoming == null) break;
                incoming = plugin.classCreated(unionPluginContext, ramlType, incoming, eventType);
            }
            return incoming;
        }

        @Override
        public FieldSpec.Builder anyFieldCreated(UnionPluginContext context, UnionTypeDeclaration union, TypeSpec.Builder typeSpec, FieldSpec.Builder anyType, EventType eventType) {
            for (UnionTypeHandlerPlugin plugin : this.plugins) {
                if (anyType == null) break;
                anyType = plugin.anyFieldCreated(context, union, typeSpec, anyType, eventType);
            }
            return anyType;
        }

        @Override
        public FieldSpec.Builder fieldBuilt(UnionPluginContext context, TypeDeclaration ramlType, FieldSpec.Builder fieldSpec, EventType eventType) {
            for (UnionTypeHandlerPlugin plugin : this.plugins) {
                if (fieldSpec == null) break;
                fieldSpec = plugin.fieldBuilt(context, ramlType, fieldSpec, eventType);
            }
            return fieldSpec;
        }
    }

    public static class Helper
    implements UnionTypeHandlerPlugin {
        @Override
        public ClassName className(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
            return currentSuggestion;
        }

        @Override
        public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
            return incoming;
        }

        @Override
        public FieldSpec.Builder anyFieldCreated(UnionPluginContext context, UnionTypeDeclaration union, TypeSpec.Builder typeSpec, FieldSpec.Builder anyType, EventType eventType) {
            return anyType;
        }

        @Override
        public FieldSpec.Builder fieldBuilt(UnionPluginContext context, TypeDeclaration ramlType, FieldSpec.Builder fieldSpec, EventType eventType) {
            return fieldSpec;
        }
    }
}

