/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.union;

import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.ramltopojo.extensions.UnionPluginContextImpl;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.ramltopojo.union.UnionTypesHelper;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionTypeHandler
implements TypeHandler {
    private final String name;
    private final UnionTypeDeclaration union;
    public static final ClassName NULL_CLASS = ClassName.get(Object.class);

    public UnionTypeHandler(String name, UnionTypeDeclaration union) {
        this.name = name;
        this.union = union;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        UnionPluginContextImpl context = new UnionPluginContextImpl(generationContext, null);
        UnionTypeHandlerPlugin plugin = generationContext.pluginsForUnions(Utils.allParents((TypeDeclaration)this.union, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0]));
        ClassName className = type == EventType.IMPLEMENTATION ? generationContext.buildDefaultClassName(Names.typeName(this.name, "Impl"), EventType.IMPLEMENTATION) : generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE);
        return plugin.className(context, this.union, className, type);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult preCreationResult) {
        UnionPluginContextImpl context = new UnionPluginContextImpl(generationContext, preCreationResult);
        ClassName interfaceName = preCreationResult.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder interf = this.getDeclaration(generationContext, context, preCreationResult);
        TypeSpec.Builder impl = this.getImplementation(interfaceName, generationContext, context, preCreationResult);
        if (interf == null) {
            return Optional.absent();
        }
        return Optional.of((Object)preCreationResult.withInterface(interf.build()).withImplementation(impl.build()));
    }

    private TypeSpec.Builder getImplementation(ClassName interfaceName, GenerationContext generationContext, UnionPluginContext context, CreationResult preCreationResult) {
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)preCreationResult.getJavaName(EventType.IMPLEMENTATION)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)interfaceName);
        if (UnionTypesHelper.isAmbiguous(this.union.of(), x -> this.findType(x.name(), (TypeDeclaration)x, generationContext))) {
            throw new GenerationException("This union is ambiguous. It's impossible to create a correct constructor for ambiguous types: " + this.union.of().stream().map(x -> this.findType(x.name(), (TypeDeclaration)x, generationContext)).collect(Collectors.toList()) + ". Use unique primitive types or classes with discriminator to solve this conflict.");
        }
        String unionEnumName = "unionType";
        ClassName unionClassInterfaceName = preCreationResult.getJavaName(EventType.INTERFACE);
        ClassName unionEnumClassName = unionClassInterfaceName.nestedClass(Names.typeName(unionEnumName));
        typeSpec.addField(FieldSpec.builder((TypeName)unionEnumClassName, (String)unionEnumName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        typeSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).build());
        MethodSpec.Builder constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Object.class), "value", new Modifier[0]);
        boolean firstConstructorArgument = true;
        typeSpec.addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", unionEnumName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.$L", new Object[]{unionEnumName}).returns((TypeName)unionEnumClassName).build());
        for (TypeDeclaration unitedType : UnionTypesHelper.sortByPriority(this.union.of())) {
            ClassName typeName = unitedType instanceof NullTypeDeclaration ? NULL_CLASS : this.findType(unitedType.name(), unitedType, generationContext).box();
            String prettyName = this.prettyName(unitedType, generationContext);
            String fieldName = Names.methodName(prettyName, "value");
            if (typeName == NULL_CLASS) {
                if (firstConstructorArgument) {
                    constructorSpec.beginControlFlow("if (value == null)", new Object[0]);
                    firstConstructorArgument = false;
                } else {
                    constructorSpec.beginControlFlow("else if (value == null)", new Object[0]);
                }
                constructorSpec.addStatement("this.$L = $T.NIL", new Object[]{unionEnumName, unionEnumClassName});
                constructorSpec.endControlFlow();
                typeSpec.addMethod(MethodSpec.methodBuilder((String)"isNil").addStatement("return this.$L == $T.NIL", new Object[]{unionEnumName, unionEnumClassName}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).build()).addMethod(MethodSpec.methodBuilder((String)"getNil").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeName).addStatement("if (!isNil()) throw new $T(\"fetching wrong type out of the union: NullType should be null\")", new Object[]{IllegalStateException.class}).addStatement("return null", new Object[0]).build()).build();
                continue;
            }
            FieldSpec.Builder fieldValueSpec = FieldSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            fieldValueSpec = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).fieldBuilt(context, unitedType, fieldValueSpec, EventType.IMPLEMENTATION);
            typeSpec.addField(fieldValueSpec.build());
            String enumName = Names.enumName(prettyName);
            String isName = Names.methodName("is", prettyName);
            String getName = Names.methodName("get", prettyName);
            if (firstConstructorArgument) {
                constructorSpec.beginControlFlow("if (value instanceof $T)", new Object[]{typeName});
                firstConstructorArgument = false;
            } else {
                constructorSpec.beginControlFlow("else if (value instanceof $T)", new Object[]{typeName});
            }
            constructorSpec.addStatement("this.$L = $T.$L", new Object[]{unionEnumName, unionEnumClassName, enumName});
            constructorSpec.addStatement("this.$L = ($T) value", new Object[]{fieldName, typeName});
            constructorSpec.endControlFlow();
            typeSpec.addMethod(MethodSpec.methodBuilder((String)isName).addStatement("return this.$L == $T.$L", new Object[]{unionEnumName, unionEnumClassName, enumName}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).build()).addMethod(MethodSpec.methodBuilder((String)getName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeName).addStatement("if (!$L()) throw new $T(\"fetching wrong type out of the union: $L\")", new Object[]{isName, IllegalStateException.class, typeName}).addStatement("return this.$L", new Object[]{fieldName}).build()).build();
        }
        constructorSpec.beginControlFlow("else", new Object[0]);
        constructorSpec.addStatement("throw new $T($S + value)", new Object[]{IllegalArgumentException.class, "Union creation is not supported for given value: "});
        constructorSpec.endControlFlow();
        typeSpec.addMethod(constructorSpec.build());
        typeSpec = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).classCreated(context, this.union, typeSpec, EventType.IMPLEMENTATION);
        if (typeSpec == null) {
            return null;
        }
        return typeSpec;
    }

    private TypeSpec.Builder getDeclaration(GenerationContext generationContext, UnionPluginContext context, CreationResult preCreationResult) {
        ClassName unionClassName = preCreationResult.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((ClassName)unionClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        typeSpec = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).classCreated(context, this.union, typeSpec, EventType.INTERFACE);
        if (typeSpec == null) {
            return null;
        }
        String unionEnumName = "unionType";
        ClassName unionEnumClassName = unionClassName.nestedClass(Names.typeName(unionEnumName));
        TypeSpec.Builder enumTypeSpec = TypeSpec.enumBuilder((ClassName)unionEnumClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        typeSpec.addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", unionEnumName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)unionEnumClassName).build());
        for (TypeDeclaration unitedType : this.union.of()) {
            if (unitedType instanceof ArrayTypeDeclaration) {
                throw new GenerationException("ramltopojo currently does not support arrays in unions");
            }
            ClassName typeName = unitedType instanceof NullTypeDeclaration ? NULL_CLASS : this.findType(unitedType.name(), unitedType, generationContext).box();
            String prettyName = this.prettyName(unitedType, generationContext);
            enumTypeSpec.addEnumConstant(Names.enumName(prettyName));
            if (typeName == NULL_CLASS) {
                typeSpec.addMethod(MethodSpec.methodBuilder((String)"isNil").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TypeName.BOOLEAN).build()).addMethod(MethodSpec.methodBuilder((String)"getNil").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)typeName).build());
                continue;
            }
            typeSpec.addMethod(MethodSpec.methodBuilder((String)Names.methodName("is", prettyName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TypeName.BOOLEAN).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", prettyName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)typeName).build());
        }
        typeSpec.addType(enumTypeSpec.build());
        return typeSpec;
    }

    private String prettyName(TypeDeclaration type, GenerationContext generationContext) {
        if (type.type() == null) {
            return type instanceof NullTypeDeclaration ? "nil" : this.shorten(this.findType(type.name(), type, generationContext).box());
        }
        return type.name();
    }

    private String shorten(TypeName typeName) {
        if (!(typeName instanceof ClassName)) {
            throw new GenerationException(typeName + this.toString() + " cannot be shortened reasonably");
        }
        return ((ClassName)typeName).simpleName();
    }

    private TypeName findType(String typeName, TypeDeclaration type, GenerationContext generationContext) {
        return TypeDeclarationType.calculateTypeName(typeName, type, generationContext, EventType.INTERFACE);
    }
}

