package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AnnotationSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractAnnotationSpecAssert<S extends AbstractAnnotationSpecAssert<S, A>, A extends AnnotationSpec> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAnnotationSpecAssert}</code> to make assertions on actual AnnotationSpec.
   * @param actual the AnnotationSpec we want to make assertions on.
   */
  protected AbstractAnnotationSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AnnotationSpec's members is equal to the given one.
   * @param members the given members to compare the actual AnnotationSpec's members to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AnnotationSpec's members is not equal to the given one.
   */
  public S hasMembers(java.util.Map members) {
    // check that actual AnnotationSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting members of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualMembers = actual.members;
    if (!Objects.areEqual(actualMembers, members)) {
      failWithMessage(assertjErrorMessage, actual, members, actualMembers);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AnnotationSpec's type is equal to the given one.
   * @param type the given type to compare the actual AnnotationSpec's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AnnotationSpec's type is not equal to the given one.
   */
  public S hasType(TypeName type) {
    // check that actual AnnotationSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeName actualType = actual.type;
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
