package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link FieldSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractFieldSpecAssert<S extends AbstractFieldSpecAssert<S, A>, A extends FieldSpec> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFieldSpecAssert}</code> to make assertions on actual FieldSpec.
   * @param actual the FieldSpec we want to make assertions on.
   */
  protected AbstractFieldSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual FieldSpec's annotations contains the given AnnotationSpec elements.
   * @param annotations the given elements that should be contained in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(AnnotationSpec... annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's annotations contains the given AnnotationSpec elements in Collection.
   * @param annotations the given elements that should be contained in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's annotations contains <b>only</b> the given AnnotationSpec elements and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(AnnotationSpec... annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's annotations contains <b>only</b> the given AnnotationSpec elements in Collection and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's annotations does not contain the given AnnotationSpec elements.
   *
   * @param annotations the given elements that should not be in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(AnnotationSpec... annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's annotations does not contain the given AnnotationSpec elements in Collection.
   *
   * @param annotations the given elements that should not be in actual FieldSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec has no annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's annotations is not empty.
   */
  public S hasNoAnnotations() {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";

    // check
    if (actual.annotations.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.annotations);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual FieldSpec's initializer is equal to the given one.
   * @param initializer the given initializer to compare the actual FieldSpec's initializer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FieldSpec's initializer is not equal to the given one.
   */
  public S hasInitializer(CodeBlock initializer) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting initializer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualInitializer = actual.initializer;
    if (!Objects.areEqual(actualInitializer, initializer)) {
      failWithMessage(assertjErrorMessage, actual, initializer, actualInitializer);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's javadoc is equal to the given one.
   * @param javadoc the given javadoc to compare the actual FieldSpec's javadoc to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FieldSpec's javadoc is not equal to the given one.
   */
  public S hasJavadoc(CodeBlock javadoc) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting javadoc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualJavadoc = actual.javadoc;
    if (!Objects.areEqual(actualJavadoc, javadoc)) {
      failWithMessage(assertjErrorMessage, actual, javadoc, actualJavadoc);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers contains the given javax.lang.model.element.Modifier elements.
   * @param modifiers the given elements that should be contained in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers contains the given javax.lang.model.element.Modifier elements in Collection.
   * @param modifiers the given elements that should be contained in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements in Collection and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements.
   *
   * @param modifiers the given elements that should not be in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements in Collection.
   *
   * @param modifiers the given elements that should not be in actual FieldSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec has no modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual FieldSpec's modifiers is not empty.
   */
  public S hasNoModifiers() {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiers but had :\n  <%s>";

    // check
    if (actual.modifiers.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.modifiers);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual FieldSpec's name is equal to the given one.
   * @param name the given name to compare the actual FieldSpec's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FieldSpec's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.name;
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FieldSpec's type is equal to the given one.
   * @param type the given type to compare the actual FieldSpec's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FieldSpec's type is not equal to the given one.
   */
  public S hasType(TypeName type) {
    // check that actual FieldSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeName actualType = actual.type;
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
