package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JavaFile} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractJavaFileAssert<S extends AbstractJavaFileAssert<S, A>, A extends JavaFile> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJavaFileAssert}</code> to make assertions on actual JavaFile.
   * @param actual the JavaFile we want to make assertions on.
   */
  protected AbstractJavaFileAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JavaFile's fileComment is equal to the given one.
   * @param fileComment the given fileComment to compare the actual JavaFile's fileComment to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JavaFile's fileComment is not equal to the given one.
   */
  public S hasFileComment(CodeBlock fileComment) {
    // check that actual JavaFile we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fileComment of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualFileComment = actual.fileComment;
    if (!Objects.areEqual(actualFileComment, fileComment)) {
      failWithMessage(assertjErrorMessage, actual, fileComment, actualFileComment);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JavaFile's packageName is equal to the given one.
   * @param packageName the given packageName to compare the actual JavaFile's packageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JavaFile's packageName is not equal to the given one.
   */
  public S hasPackageName(String packageName) {
    // check that actual JavaFile we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting packageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualPackageName = actual.packageName;
    if (!Objects.areEqual(actualPackageName, packageName)) {
      failWithMessage(assertjErrorMessage, actual, packageName, actualPackageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JavaFile is skipJavaLangImports.
   * @return this assertion object.
   * @throws AssertionError - if the actual JavaFile is not skipJavaLangImports.
   */
  public S isSkipJavaLangImports() {
    // check that actual JavaFile we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.skipJavaLangImports) {
      failWithMessage("\nExpecting that actual JavaFile is skipJavaLangImports but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JavaFile is not skipJavaLangImports.
   * @return this assertion object.
   * @throws AssertionError - if the actual JavaFile is skipJavaLangImports.
   */
  public S isNotSkipJavaLangImports() {
    // check that actual JavaFile we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.skipJavaLangImports) {
      failWithMessage("\nExpecting that actual JavaFile is not skipJavaLangImports but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JavaFile's typeSpec is equal to the given one.
   * @param typeSpec the given typeSpec to compare the actual JavaFile's typeSpec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JavaFile's typeSpec is not equal to the given one.
   */
  public S hasTypeSpec(TypeSpec typeSpec) {
    // check that actual JavaFile we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting typeSpec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeSpec actualTypeSpec = actual.typeSpec;
    if (!Objects.areEqual(actualTypeSpec, typeSpec)) {
      failWithMessage(assertjErrorMessage, actual, typeSpec, actualTypeSpec);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
