package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MethodSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMethodSpecAssert<S extends AbstractMethodSpecAssert<S, A>, A extends MethodSpec> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMethodSpecAssert}</code> to make assertions on actual MethodSpec.
   * @param actual the MethodSpec we want to make assertions on.
   */
  protected AbstractMethodSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MethodSpec is constructor.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec is not constructor.
   */
  public S isConstructor() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isConstructor()) {
      failWithMessage("\nExpecting that actual MethodSpec is constructor but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec is not constructor.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec is constructor.
   */
  public S isNotConstructor() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isConstructor()) {
      failWithMessage("\nExpecting that actual MethodSpec is not constructor but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations contains the given AnnotationSpec elements.
   * @param annotations the given elements that should be contained in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(AnnotationSpec... annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations contains the given AnnotationSpec elements in Collection.
   * @param annotations the given elements that should be contained in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations contains <b>only</b> the given AnnotationSpec elements and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(AnnotationSpec... annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations contains <b>only</b> the given AnnotationSpec elements in Collection and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations does not contain the given AnnotationSpec elements.
   *
   * @param annotations the given elements that should not be in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(AnnotationSpec... annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's annotations does not contain the given AnnotationSpec elements in Collection.
   *
   * @param annotations the given elements that should not be in actual MethodSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec has no annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's annotations is not empty.
   */
  public S hasNoAnnotations() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";

    // check
    if (actual.annotations.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.annotations);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual MethodSpec's code is equal to the given one.
   * @param code the given code to compare the actual MethodSpec's code to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec's code is not equal to the given one.
   */
  public S hasCode(CodeBlock code) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting code of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualCode = actual.code;
    if (!Objects.areEqual(actualCode, code)) {
      failWithMessage(assertjErrorMessage, actual, code, actualCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's defaultValue is equal to the given one.
   * @param defaultValue the given defaultValue to compare the actual MethodSpec's defaultValue to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec's defaultValue is not equal to the given one.
   */
  public S hasDefaultValue(CodeBlock defaultValue) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting defaultValue of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualDefaultValue = actual.defaultValue;
    if (!Objects.areEqual(actualDefaultValue, defaultValue)) {
      failWithMessage(assertjErrorMessage, actual, defaultValue, actualDefaultValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions contains the given TypeName elements.
   * @param exceptions the given elements that should be contained in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions does not contain all given TypeName elements.
   */
  public S hasExceptions(TypeName... exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (exceptions == null) failWithMessage("Expecting exceptions parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.exceptions, exceptions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions contains the given TypeName elements in Collection.
   * @param exceptions the given elements that should be contained in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions does not contain all given TypeName elements.
   */
  public S hasExceptions(java.util.Collection<? extends TypeName> exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (exceptions == null) {
      failWithMessage("Expecting exceptions parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.exceptions, exceptions.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param exceptions the given elements that should be contained in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions does not contain all given TypeName elements.
   */
  public S hasOnlyExceptions(TypeName... exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (exceptions == null) failWithMessage("Expecting exceptions parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.exceptions, exceptions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param exceptions the given elements that should be contained in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions does not contain all given TypeName elements.
   */
  public S hasOnlyExceptions(java.util.Collection<? extends TypeName> exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (exceptions == null) {
      failWithMessage("Expecting exceptions parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.exceptions, exceptions.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions does not contain the given TypeName elements.
   *
   * @param exceptions the given elements that should not be in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions contains any given TypeName elements.
   */
  public S doesNotHaveExceptions(TypeName... exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (exceptions == null) failWithMessage("Expecting exceptions parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.exceptions, exceptions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's exceptions does not contain the given TypeName elements in Collection.
   *
   * @param exceptions the given elements that should not be in actual MethodSpec's exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions contains any given TypeName elements.
   */
  public S doesNotHaveExceptions(java.util.Collection<? extends TypeName> exceptions) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (exceptions == null) {
      failWithMessage("Expecting exceptions parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.exceptions, exceptions.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec has no exceptions.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's exceptions is not empty.
   */
  public S hasNoExceptions() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have exceptions but had :\n  <%s>";

    // check
    if (actual.exceptions.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.exceptions);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual MethodSpec's javadoc is equal to the given one.
   * @param javadoc the given javadoc to compare the actual MethodSpec's javadoc to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec's javadoc is not equal to the given one.
   */
  public S hasJavadoc(CodeBlock javadoc) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting javadoc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualJavadoc = actual.javadoc;
    if (!Objects.areEqual(actualJavadoc, javadoc)) {
      failWithMessage(assertjErrorMessage, actual, javadoc, actualJavadoc);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers contains the given javax.lang.model.element.Modifier elements.
   * @param modifiers the given elements that should be contained in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers contains the given javax.lang.model.element.Modifier elements in Collection.
   * @param modifiers the given elements that should be contained in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements in Collection and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements.
   *
   * @param modifiers the given elements that should not be in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements in Collection.
   *
   * @param modifiers the given elements that should not be in actual MethodSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec has no modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's modifiers is not empty.
   */
  public S hasNoModifiers() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiers but had :\n  <%s>";

    // check
    if (actual.modifiers.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.modifiers);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual MethodSpec's name is equal to the given one.
   * @param name the given name to compare the actual MethodSpec's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.name;
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters contains the given ParameterSpec elements.
   * @param parameters the given elements that should be contained in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters does not contain all given ParameterSpec elements.
   */
  public S hasParameters(ParameterSpec... parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec varargs is not null.
    if (parameters == null) failWithMessage("Expecting parameters parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.parameters, parameters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters contains the given ParameterSpec elements in Collection.
   * @param parameters the given elements that should be contained in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters does not contain all given ParameterSpec elements.
   */
  public S hasParameters(java.util.Collection<? extends ParameterSpec> parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec collection is not null.
    if (parameters == null) {
      failWithMessage("Expecting parameters parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.parameters, parameters.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters contains <b>only</b> the given ParameterSpec elements and nothing else in whatever order.
   * @param parameters the given elements that should be contained in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters does not contain all given ParameterSpec elements.
   */
  public S hasOnlyParameters(ParameterSpec... parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec varargs is not null.
    if (parameters == null) failWithMessage("Expecting parameters parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.parameters, parameters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters contains <b>only</b> the given ParameterSpec elements in Collection and nothing else in whatever order.
   * @param parameters the given elements that should be contained in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters does not contain all given ParameterSpec elements.
   */
  public S hasOnlyParameters(java.util.Collection<? extends ParameterSpec> parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec collection is not null.
    if (parameters == null) {
      failWithMessage("Expecting parameters parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.parameters, parameters.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters does not contain the given ParameterSpec elements.
   *
   * @param parameters the given elements that should not be in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters contains any given ParameterSpec elements.
   */
  public S doesNotHaveParameters(ParameterSpec... parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec varargs is not null.
    if (parameters == null) failWithMessage("Expecting parameters parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.parameters, parameters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's parameters does not contain the given ParameterSpec elements in Collection.
   *
   * @param parameters the given elements that should not be in actual MethodSpec's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters contains any given ParameterSpec elements.
   */
  public S doesNotHaveParameters(java.util.Collection<? extends ParameterSpec> parameters) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given ParameterSpec collection is not null.
    if (parameters == null) {
      failWithMessage("Expecting parameters parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.parameters, parameters.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec has no parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's parameters is not empty.
   */
  public S hasNoParameters() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have parameters but had :\n  <%s>";

    // check
    if (actual.parameters.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.parameters);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual MethodSpec's returnType is equal to the given one.
   * @param returnType the given returnType to compare the actual MethodSpec's returnType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec's returnType is not equal to the given one.
   */
  public S hasReturnType(TypeName returnType) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting returnType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeName actualReturnType = actual.returnType;
    if (!Objects.areEqual(actualReturnType, returnType)) {
      failWithMessage(assertjErrorMessage, actual, returnType, actualReturnType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables contains the given TypeVariableName elements.
   * @param typeVariables the given elements that should be contained in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasTypeVariables(TypeVariableName... typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables contains the given TypeVariableName elements in Collection.
   * @param typeVariables the given elements that should be contained in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables contains <b>only</b> the given TypeVariableName elements and nothing else in whatever order.
   * @param typeVariables the given elements that should be contained in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasOnlyTypeVariables(TypeVariableName... typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables contains <b>only</b> the given TypeVariableName elements in Collection and nothing else in whatever order.
   * @param typeVariables the given elements that should be contained in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasOnlyTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables does not contain the given TypeVariableName elements.
   *
   * @param typeVariables the given elements that should not be in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables contains any given TypeVariableName elements.
   */
  public S doesNotHaveTypeVariables(TypeVariableName... typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec's typeVariables does not contain the given TypeVariableName elements in Collection.
   *
   * @param typeVariables the given elements that should not be in actual MethodSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables contains any given TypeVariableName elements.
   */
  public S doesNotHaveTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec has no typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual MethodSpec's typeVariables is not empty.
   */
  public S hasNoTypeVariables() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeVariables but had :\n  <%s>";

    // check
    if (actual.typeVariables.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.typeVariables);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual MethodSpec is varargs.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec is not varargs.
   */
  public S isVarargs() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.varargs) {
      failWithMessage("\nExpecting that actual MethodSpec is varargs but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MethodSpec is not varargs.
   * @return this assertion object.
   * @throws AssertionError - if the actual MethodSpec is varargs.
   */
  public S isNotVarargs() {
    // check that actual MethodSpec we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.varargs) {
      failWithMessage("\nExpecting that actual MethodSpec is not varargs but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
