package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link TypeName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractTypeNameAssert<S extends AbstractTypeNameAssert<S, A>, A extends TypeName> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypeNameAssert}</code> to make assertions on actual TypeName.
   * @param actual the TypeName we want to make assertions on.
   */
  protected AbstractTypeNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TypeName is annotated.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is not annotated.
   */
  public S isAnnotated() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isAnnotated()) {
      failWithMessage("\nExpecting that actual TypeName is annotated but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName is not annotated.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is annotated.
   */
  public S isNotAnnotated() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isAnnotated()) {
      failWithMessage("\nExpecting that actual TypeName is not annotated but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName is boxed primitive.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is not boxed primitive.
   */
  public S isBoxedPrimitive() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isBoxedPrimitive()) {
      failWithMessage("\nExpecting that actual TypeName is boxed primitive but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName is not boxed primitive.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is boxed primitive.
   */
  public S isNotBoxedPrimitive() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isBoxedPrimitive()) {
      failWithMessage("\nExpecting that actual TypeName is not boxed primitive but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName is primitive.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is not primitive.
   */
  public S isPrimitive() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isPrimitive()) {
      failWithMessage("\nExpecting that actual TypeName is primitive but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName is not primitive.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeName is primitive.
   */
  public S isNotPrimitive() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isPrimitive()) {
      failWithMessage("\nExpecting that actual TypeName is not primitive but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations contains the given AnnotationSpec elements.
   * @param annotations the given elements that should be contained in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations contains the given AnnotationSpec elements in Collection.
   * @param annotations the given elements that should be contained in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations contains <b>only</b> the given AnnotationSpec elements and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations contains <b>only</b> the given AnnotationSpec elements in Collection and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations does not contain the given AnnotationSpec elements.
   *
   * @param annotations the given elements that should not be in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName's annotations does not contain the given AnnotationSpec elements in Collection.
   *
   * @param annotations the given elements that should not be in actual TypeName's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeName has no annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeName's annotations is not empty.
   */
  public S hasNoAnnotations() {
    // check that actual TypeName we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";

    // check
    if (actual.annotations.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.annotations);
    }

    // return the current assertion for method chaining
    return myself;
  }


}
