package com.squareup.javapoet;

/**
 * Abstract base class for {@link ClassName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractClassNameAssert<S extends AbstractClassNameAssert<S, A>, A extends ClassName> extends AbstractTypeNameAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClassNameAssert}</code> to make assertions on actual ClassName.
   * @param actual the ClassName we want to make assertions on.
   */
  protected AbstractClassNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClassName is annotated.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClassName is not annotated.
   */
  public S isAnnotated() {
    // check that actual ClassName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isAnnotated()) {
      failWithMessage("\nExpecting that actual ClassName is annotated but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClassName is not annotated.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClassName is annotated.
   */
  public S isNotAnnotated() {
    // check that actual ClassName we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isAnnotated()) {
      failWithMessage("\nExpecting that actual ClassName is not annotated but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
