package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;

/**
 * Abstract base class for {@link CodeBlock} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractCodeBlockAssert<S extends AbstractCodeBlockAssert<S, A>, A extends CodeBlock> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCodeBlockAssert}</code> to make assertions on actual CodeBlock.
   * @param actual the CodeBlock we want to make assertions on.
   */
  protected AbstractCodeBlockAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CodeBlock is empty.
   * @return this assertion object.
   * @throws AssertionError - if the actual CodeBlock is not empty.
   */
  public S isEmpty() {
    // check that actual CodeBlock we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isEmpty()) {
      failWithMessage("\nExpecting that actual CodeBlock is empty but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CodeBlock is not empty.
   * @return this assertion object.
   * @throws AssertionError - if the actual CodeBlock is empty.
   */
  public S isNotEmpty() {
    // check that actual CodeBlock we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isEmpty()) {
      failWithMessage("\nExpecting that actual CodeBlock is not empty but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
