package com.squareup.javapoet;

import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ParameterizedTypeName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractParameterizedTypeNameAssert<S extends AbstractParameterizedTypeNameAssert<S, A>, A extends ParameterizedTypeName> extends AbstractTypeNameAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractParameterizedTypeNameAssert}</code> to make assertions on actual ParameterizedTypeName.
   * @param actual the ParameterizedTypeName we want to make assertions on.
   */
  protected AbstractParameterizedTypeNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ParameterizedTypeName's rawType is equal to the given one.
   * @param rawType the given rawType to compare the actual ParameterizedTypeName's rawType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterizedTypeName's rawType is not equal to the given one.
   */
  public S hasRawType(ClassName rawType) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rawType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    ClassName actualRawType = actual.rawType;
    if (!Objects.areEqual(actualRawType, rawType)) {
      failWithMessage(assertjErrorMessage, actual, rawType, actualRawType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments contains the given TypeName elements.
   * @param typeArguments the given elements that should be contained in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments does not contain all given TypeName elements.
   */
  public S hasTypeArguments(TypeName... typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (typeArguments == null) failWithMessage("Expecting typeArguments parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeArguments, typeArguments);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments contains the given TypeName elements in Collection.
   * @param typeArguments the given elements that should be contained in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments does not contain all given TypeName elements.
   */
  public S hasTypeArguments(java.util.Collection<? extends TypeName> typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (typeArguments == null) {
      failWithMessage("Expecting typeArguments parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeArguments, typeArguments.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param typeArguments the given elements that should be contained in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments does not contain all given TypeName elements.
   */
  public S hasOnlyTypeArguments(TypeName... typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (typeArguments == null) failWithMessage("Expecting typeArguments parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeArguments, typeArguments);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param typeArguments the given elements that should be contained in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments does not contain all given TypeName elements.
   */
  public S hasOnlyTypeArguments(java.util.Collection<? extends TypeName> typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (typeArguments == null) {
      failWithMessage("Expecting typeArguments parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeArguments, typeArguments.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments does not contain the given TypeName elements.
   *
   * @param typeArguments the given elements that should not be in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments contains any given TypeName elements.
   */
  public S doesNotHaveTypeArguments(TypeName... typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (typeArguments == null) failWithMessage("Expecting typeArguments parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeArguments, typeArguments);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName's typeArguments does not contain the given TypeName elements in Collection.
   *
   * @param typeArguments the given elements that should not be in actual ParameterizedTypeName's typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments contains any given TypeName elements.
   */
  public S doesNotHaveTypeArguments(java.util.Collection<? extends TypeName> typeArguments) {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (typeArguments == null) {
      failWithMessage("Expecting typeArguments parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeArguments, typeArguments.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterizedTypeName has no typeArguments.
   * @return this assertion object.
   * @throws AssertionError if the actual ParameterizedTypeName's typeArguments is not empty.
   */
  public S hasNoTypeArguments() {
    // check that actual ParameterizedTypeName we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeArguments but had :\n  <%s>";

    // check
    if (actual.typeArguments.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.typeArguments);
    }

    // return the current assertion for method chaining
    return myself;
  }


}
