package com.squareup.javapoet;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TypeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractTypeSpecAssert<S extends AbstractTypeSpecAssert<S, A>, A extends TypeSpec> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypeSpecAssert}</code> to make assertions on actual TypeSpec.
   * @param actual the TypeSpec we want to make assertions on.
   */
  protected AbstractTypeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TypeSpec's annotations contains the given AnnotationSpec elements.
   * @param annotations the given elements that should be contained in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's annotations contains the given AnnotationSpec elements in Collection.
   * @param annotations the given elements that should be contained in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's annotations contains <b>only</b> the given AnnotationSpec elements and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's annotations contains <b>only</b> the given AnnotationSpec elements in Collection and nothing else in whatever order.
   * @param annotations the given elements that should be contained in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations does not contain all given AnnotationSpec elements.
   */
  public S hasOnlyAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's annotations does not contain the given AnnotationSpec elements.
   *
   * @param annotations the given elements that should not be in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(AnnotationSpec... annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec varargs is not null.
    if (annotations == null) failWithMessage("Expecting annotations parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's annotations does not contain the given AnnotationSpec elements in Collection.
   *
   * @param annotations the given elements that should not be in actual TypeSpec's annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations contains any given AnnotationSpec elements.
   */
  public S doesNotHaveAnnotations(java.util.Collection<? extends AnnotationSpec> annotations) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given AnnotationSpec collection is not null.
    if (annotations == null) {
      failWithMessage("Expecting annotations parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.annotations, annotations.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no annotations.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's annotations is not empty.
   */
  public S hasNoAnnotations() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";

    // check
    if (actual.annotations.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.annotations);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's anonymousTypeArguments is equal to the given one.
   * @param anonymousTypeArguments the given anonymousTypeArguments to compare the actual TypeSpec's anonymousTypeArguments to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's anonymousTypeArguments is not equal to the given one.
   */
  public S hasAnonymousTypeArguments(CodeBlock anonymousTypeArguments) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting anonymousTypeArguments of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualAnonymousTypeArguments = actual.anonymousTypeArguments;
    if (!Objects.areEqual(actualAnonymousTypeArguments, anonymousTypeArguments)) {
      failWithMessage(assertjErrorMessage, actual, anonymousTypeArguments, actualAnonymousTypeArguments);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's enumConstants is equal to the given one.
   * @param enumConstants the given enumConstants to compare the actual TypeSpec's enumConstants to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's enumConstants is not equal to the given one.
   */
  public S hasEnumConstants(java.util.Map enumConstants) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting enumConstants of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualEnumConstants = actual.enumConstants;
    if (!Objects.areEqual(actualEnumConstants, enumConstants)) {
      failWithMessage(assertjErrorMessage, actual, enumConstants, actualEnumConstants);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs contains the given FieldSpec elements.
   * @param fieldSpecs the given elements that should be contained in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs does not contain all given FieldSpec elements.
   */
  public S hasFieldSpecs(FieldSpec... fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec varargs is not null.
    if (fieldSpecs == null) failWithMessage("Expecting fieldSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.fieldSpecs, fieldSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs contains the given FieldSpec elements in Collection.
   * @param fieldSpecs the given elements that should be contained in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs does not contain all given FieldSpec elements.
   */
  public S hasFieldSpecs(java.util.Collection<? extends FieldSpec> fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec collection is not null.
    if (fieldSpecs == null) {
      failWithMessage("Expecting fieldSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.fieldSpecs, fieldSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs contains <b>only</b> the given FieldSpec elements and nothing else in whatever order.
   * @param fieldSpecs the given elements that should be contained in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs does not contain all given FieldSpec elements.
   */
  public S hasOnlyFieldSpecs(FieldSpec... fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec varargs is not null.
    if (fieldSpecs == null) failWithMessage("Expecting fieldSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.fieldSpecs, fieldSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs contains <b>only</b> the given FieldSpec elements in Collection and nothing else in whatever order.
   * @param fieldSpecs the given elements that should be contained in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs does not contain all given FieldSpec elements.
   */
  public S hasOnlyFieldSpecs(java.util.Collection<? extends FieldSpec> fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec collection is not null.
    if (fieldSpecs == null) {
      failWithMessage("Expecting fieldSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.fieldSpecs, fieldSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs does not contain the given FieldSpec elements.
   *
   * @param fieldSpecs the given elements that should not be in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs contains any given FieldSpec elements.
   */
  public S doesNotHaveFieldSpecs(FieldSpec... fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec varargs is not null.
    if (fieldSpecs == null) failWithMessage("Expecting fieldSpecs parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.fieldSpecs, fieldSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's fieldSpecs does not contain the given FieldSpec elements in Collection.
   *
   * @param fieldSpecs the given elements that should not be in actual TypeSpec's fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs contains any given FieldSpec elements.
   */
  public S doesNotHaveFieldSpecs(java.util.Collection<? extends FieldSpec> fieldSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given FieldSpec collection is not null.
    if (fieldSpecs == null) {
      failWithMessage("Expecting fieldSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.fieldSpecs, fieldSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no fieldSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's fieldSpecs is not empty.
   */
  public S hasNoFieldSpecs() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have fieldSpecs but had :\n  <%s>";

    // check
    if (actual.fieldSpecs.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.fieldSpecs);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's initializerBlock is equal to the given one.
   * @param initializerBlock the given initializerBlock to compare the actual TypeSpec's initializerBlock to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's initializerBlock is not equal to the given one.
   */
  public S hasInitializerBlock(CodeBlock initializerBlock) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting initializerBlock of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualInitializerBlock = actual.initializerBlock;
    if (!Objects.areEqual(actualInitializerBlock, initializerBlock)) {
      failWithMessage(assertjErrorMessage, actual, initializerBlock, actualInitializerBlock);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's javadoc is equal to the given one.
   * @param javadoc the given javadoc to compare the actual TypeSpec's javadoc to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's javadoc is not equal to the given one.
   */
  public S hasJavadoc(CodeBlock javadoc) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting javadoc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualJavadoc = actual.javadoc;
    if (!Objects.areEqual(actualJavadoc, javadoc)) {
      failWithMessage(assertjErrorMessage, actual, javadoc, actualJavadoc);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's kind is equal to the given one.
   * @param kind the given kind to compare the actual TypeSpec's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's kind is not equal to the given one.
   */
  public S hasKind(TypeSpec.Kind kind) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeSpec.Kind actualKind = actual.kind;
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs contains the given MethodSpec elements.
   * @param methodSpecs the given elements that should be contained in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs does not contain all given MethodSpec elements.
   */
  public S hasMethodSpecs(MethodSpec... methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec varargs is not null.
    if (methodSpecs == null) failWithMessage("Expecting methodSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.methodSpecs, methodSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs contains the given MethodSpec elements in Collection.
   * @param methodSpecs the given elements that should be contained in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs does not contain all given MethodSpec elements.
   */
  public S hasMethodSpecs(java.util.Collection<? extends MethodSpec> methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec collection is not null.
    if (methodSpecs == null) {
      failWithMessage("Expecting methodSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.methodSpecs, methodSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs contains <b>only</b> the given MethodSpec elements and nothing else in whatever order.
   * @param methodSpecs the given elements that should be contained in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs does not contain all given MethodSpec elements.
   */
  public S hasOnlyMethodSpecs(MethodSpec... methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec varargs is not null.
    if (methodSpecs == null) failWithMessage("Expecting methodSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.methodSpecs, methodSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs contains <b>only</b> the given MethodSpec elements in Collection and nothing else in whatever order.
   * @param methodSpecs the given elements that should be contained in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs does not contain all given MethodSpec elements.
   */
  public S hasOnlyMethodSpecs(java.util.Collection<? extends MethodSpec> methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec collection is not null.
    if (methodSpecs == null) {
      failWithMessage("Expecting methodSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.methodSpecs, methodSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs does not contain the given MethodSpec elements.
   *
   * @param methodSpecs the given elements that should not be in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs contains any given MethodSpec elements.
   */
  public S doesNotHaveMethodSpecs(MethodSpec... methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec varargs is not null.
    if (methodSpecs == null) failWithMessage("Expecting methodSpecs parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.methodSpecs, methodSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's methodSpecs does not contain the given MethodSpec elements in Collection.
   *
   * @param methodSpecs the given elements that should not be in actual TypeSpec's methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs contains any given MethodSpec elements.
   */
  public S doesNotHaveMethodSpecs(java.util.Collection<? extends MethodSpec> methodSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given MethodSpec collection is not null.
    if (methodSpecs == null) {
      failWithMessage("Expecting methodSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.methodSpecs, methodSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no methodSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's methodSpecs is not empty.
   */
  public S hasNoMethodSpecs() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have methodSpecs but had :\n  <%s>";

    // check
    if (actual.methodSpecs.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.methodSpecs);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's modifiers contains the given javax.lang.model.element.Modifier elements.
   * @param modifiers the given elements that should be contained in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's modifiers contains the given javax.lang.model.element.Modifier elements in Collection.
   * @param modifiers the given elements that should be contained in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's modifiers contains <b>only</b> the given javax.lang.model.element.Modifier elements in Collection and nothing else in whatever order.
   * @param modifiers the given elements that should be contained in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers does not contain all given javax.lang.model.element.Modifier elements.
   */
  public S hasOnlyModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements.
   *
   * @param modifiers the given elements that should not be in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(javax.lang.model.element.Modifier... modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier varargs is not null.
    if (modifiers == null) failWithMessage("Expecting modifiers parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's modifiers does not contain the given javax.lang.model.element.Modifier elements in Collection.
   *
   * @param modifiers the given elements that should not be in actual TypeSpec's modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers contains any given javax.lang.model.element.Modifier elements.
   */
  public S doesNotHaveModifiers(java.util.Collection<? extends javax.lang.model.element.Modifier> modifiers) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Modifier collection is not null.
    if (modifiers == null) {
      failWithMessage("Expecting modifiers parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.modifiers, modifiers.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no modifiers.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's modifiers is not empty.
   */
  public S hasNoModifiers() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiers but had :\n  <%s>";

    // check
    if (actual.modifiers.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.modifiers);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's name is equal to the given one.
   * @param name the given name to compare the actual TypeSpec's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.name;
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements contains the given javax.lang.model.element.Element elements.
   * @param originatingElements the given elements that should be contained in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements does not contain all given javax.lang.model.element.Element elements.
   */
  public S hasOriginatingElements(javax.lang.model.element.Element... originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element varargs is not null.
    if (originatingElements == null) failWithMessage("Expecting originatingElements parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.originatingElements, originatingElements);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements contains the given javax.lang.model.element.Element elements in Collection.
   * @param originatingElements the given elements that should be contained in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements does not contain all given javax.lang.model.element.Element elements.
   */
  public S hasOriginatingElements(java.util.Collection<? extends javax.lang.model.element.Element> originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element collection is not null.
    if (originatingElements == null) {
      failWithMessage("Expecting originatingElements parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.originatingElements, originatingElements.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements contains <b>only</b> the given javax.lang.model.element.Element elements and nothing else in whatever order.
   * @param originatingElements the given elements that should be contained in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements does not contain all given javax.lang.model.element.Element elements.
   */
  public S hasOnlyOriginatingElements(javax.lang.model.element.Element... originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element varargs is not null.
    if (originatingElements == null) failWithMessage("Expecting originatingElements parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.originatingElements, originatingElements);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements contains <b>only</b> the given javax.lang.model.element.Element elements in Collection and nothing else in whatever order.
   * @param originatingElements the given elements that should be contained in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements does not contain all given javax.lang.model.element.Element elements.
   */
  public S hasOnlyOriginatingElements(java.util.Collection<? extends javax.lang.model.element.Element> originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element collection is not null.
    if (originatingElements == null) {
      failWithMessage("Expecting originatingElements parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.originatingElements, originatingElements.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements does not contain the given javax.lang.model.element.Element elements.
   *
   * @param originatingElements the given elements that should not be in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements contains any given javax.lang.model.element.Element elements.
   */
  public S doesNotHaveOriginatingElements(javax.lang.model.element.Element... originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element varargs is not null.
    if (originatingElements == null) failWithMessage("Expecting originatingElements parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.originatingElements, originatingElements);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's originatingElements does not contain the given javax.lang.model.element.Element elements in Collection.
   *
   * @param originatingElements the given elements that should not be in actual TypeSpec's originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements contains any given javax.lang.model.element.Element elements.
   */
  public S doesNotHaveOriginatingElements(java.util.Collection<? extends javax.lang.model.element.Element> originatingElements) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given javax.lang.model.element.Element collection is not null.
    if (originatingElements == null) {
      failWithMessage("Expecting originatingElements parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.originatingElements, originatingElements.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no originatingElements.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's originatingElements is not empty.
   */
  public S hasNoOriginatingElements() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have originatingElements but had :\n  <%s>";

    // check
    if (actual.originatingElements.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.originatingElements);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's staticBlock is equal to the given one.
   * @param staticBlock the given staticBlock to compare the actual TypeSpec's staticBlock to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's staticBlock is not equal to the given one.
   */
  public S hasStaticBlock(CodeBlock staticBlock) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting staticBlock of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    CodeBlock actualStaticBlock = actual.staticBlock;
    if (!Objects.areEqual(actualStaticBlock, staticBlock)) {
      failWithMessage(assertjErrorMessage, actual, staticBlock, actualStaticBlock);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superclass is equal to the given one.
   * @param superclass the given superclass to compare the actual TypeSpec's superclass to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeSpec's superclass is not equal to the given one.
   */
  public S hasSuperclass(TypeName superclass) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting superclass of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeName actualSuperclass = actual.superclass;
    if (!Objects.areEqual(actualSuperclass, superclass)) {
      failWithMessage(assertjErrorMessage, actual, superclass, actualSuperclass);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces contains the given TypeName elements.
   * @param superinterfaces the given elements that should be contained in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces does not contain all given TypeName elements.
   */
  public S hasSuperinterfaces(TypeName... superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (superinterfaces == null) failWithMessage("Expecting superinterfaces parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.superinterfaces, superinterfaces);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces contains the given TypeName elements in Collection.
   * @param superinterfaces the given elements that should be contained in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces does not contain all given TypeName elements.
   */
  public S hasSuperinterfaces(java.util.Collection<? extends TypeName> superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (superinterfaces == null) {
      failWithMessage("Expecting superinterfaces parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.superinterfaces, superinterfaces.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param superinterfaces the given elements that should be contained in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces does not contain all given TypeName elements.
   */
  public S hasOnlySuperinterfaces(TypeName... superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (superinterfaces == null) failWithMessage("Expecting superinterfaces parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.superinterfaces, superinterfaces);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param superinterfaces the given elements that should be contained in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces does not contain all given TypeName elements.
   */
  public S hasOnlySuperinterfaces(java.util.Collection<? extends TypeName> superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (superinterfaces == null) {
      failWithMessage("Expecting superinterfaces parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.superinterfaces, superinterfaces.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces does not contain the given TypeName elements.
   *
   * @param superinterfaces the given elements that should not be in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces contains any given TypeName elements.
   */
  public S doesNotHaveSuperinterfaces(TypeName... superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (superinterfaces == null) failWithMessage("Expecting superinterfaces parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.superinterfaces, superinterfaces);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's superinterfaces does not contain the given TypeName elements in Collection.
   *
   * @param superinterfaces the given elements that should not be in actual TypeSpec's superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces contains any given TypeName elements.
   */
  public S doesNotHaveSuperinterfaces(java.util.Collection<? extends TypeName> superinterfaces) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (superinterfaces == null) {
      failWithMessage("Expecting superinterfaces parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.superinterfaces, superinterfaces.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no superinterfaces.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's superinterfaces is not empty.
   */
  public S hasNoSuperinterfaces() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have superinterfaces but had :\n  <%s>";

    // check
    if (actual.superinterfaces.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.superinterfaces);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's typeSpecs contains the given TypeSpec elements.
   * @param typeSpecs the given elements that should be contained in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs does not contain all given TypeSpec elements.
   */
  public S hasTypeSpecs(TypeSpec... typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec varargs is not null.
    if (typeSpecs == null) failWithMessage("Expecting typeSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeSpecs, typeSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeSpecs contains the given TypeSpec elements in Collection.
   * @param typeSpecs the given elements that should be contained in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs does not contain all given TypeSpec elements.
   */
  public S hasTypeSpecs(java.util.Collection<? extends TypeSpec> typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec collection is not null.
    if (typeSpecs == null) {
      failWithMessage("Expecting typeSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeSpecs, typeSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeSpecs contains <b>only</b> the given TypeSpec elements and nothing else in whatever order.
   * @param typeSpecs the given elements that should be contained in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs does not contain all given TypeSpec elements.
   */
  public S hasOnlyTypeSpecs(TypeSpec... typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec varargs is not null.
    if (typeSpecs == null) failWithMessage("Expecting typeSpecs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeSpecs, typeSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeSpecs contains <b>only</b> the given TypeSpec elements in Collection and nothing else in whatever order.
   * @param typeSpecs the given elements that should be contained in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs does not contain all given TypeSpec elements.
   */
  public S hasOnlyTypeSpecs(java.util.Collection<? extends TypeSpec> typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec collection is not null.
    if (typeSpecs == null) {
      failWithMessage("Expecting typeSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeSpecs, typeSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeSpecs does not contain the given TypeSpec elements.
   *
   * @param typeSpecs the given elements that should not be in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs contains any given TypeSpec elements.
   */
  public S doesNotHaveTypeSpecs(TypeSpec... typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec varargs is not null.
    if (typeSpecs == null) failWithMessage("Expecting typeSpecs parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeSpecs, typeSpecs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeSpecs does not contain the given TypeSpec elements in Collection.
   *
   * @param typeSpecs the given elements that should not be in actual TypeSpec's typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs contains any given TypeSpec elements.
   */
  public S doesNotHaveTypeSpecs(java.util.Collection<? extends TypeSpec> typeSpecs) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeSpec collection is not null.
    if (typeSpecs == null) {
      failWithMessage("Expecting typeSpecs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeSpecs, typeSpecs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no typeSpecs.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeSpecs is not empty.
   */
  public S hasNoTypeSpecs() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeSpecs but had :\n  <%s>";

    // check
    if (actual.typeSpecs.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.typeSpecs);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeSpec's typeVariables contains the given TypeVariableName elements.
   * @param typeVariables the given elements that should be contained in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasTypeVariables(TypeVariableName... typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeVariables contains the given TypeVariableName elements in Collection.
   * @param typeVariables the given elements that should be contained in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeVariables contains <b>only</b> the given TypeVariableName elements and nothing else in whatever order.
   * @param typeVariables the given elements that should be contained in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasOnlyTypeVariables(TypeVariableName... typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeVariables contains <b>only</b> the given TypeVariableName elements in Collection and nothing else in whatever order.
   * @param typeVariables the given elements that should be contained in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables does not contain all given TypeVariableName elements.
   */
  public S hasOnlyTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeVariables does not contain the given TypeVariableName elements.
   *
   * @param typeVariables the given elements that should not be in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables contains any given TypeVariableName elements.
   */
  public S doesNotHaveTypeVariables(TypeVariableName... typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName varargs is not null.
    if (typeVariables == null) failWithMessage("Expecting typeVariables parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeVariables, typeVariables);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec's typeVariables does not contain the given TypeVariableName elements in Collection.
   *
   * @param typeVariables the given elements that should not be in actual TypeSpec's typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables contains any given TypeVariableName elements.
   */
  public S doesNotHaveTypeVariables(java.util.Collection<? extends TypeVariableName> typeVariables) {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // check that given TypeVariableName collection is not null.
    if (typeVariables == null) {
      failWithMessage("Expecting typeVariables parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.typeVariables, typeVariables.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeSpec has no typeVariables.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeSpec's typeVariables is not empty.
   */
  public S hasNoTypeVariables() {
    // check that actual TypeSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeVariables but had :\n  <%s>";

    // check
    if (actual.typeVariables.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.typeVariables);
    }

    // return the current assertion for method chaining
    return myself;
  }


}
