package com.squareup.javapoet;

import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link WildcardTypeName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractWildcardTypeNameAssert<S extends AbstractWildcardTypeNameAssert<S, A>, A extends WildcardTypeName> extends AbstractTypeNameAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWildcardTypeNameAssert}</code> to make assertions on actual WildcardTypeName.
   * @param actual the WildcardTypeName we want to make assertions on.
   */
  protected AbstractWildcardTypeNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds contains the given TypeName elements.
   * @param lowerBounds the given elements that should be contained in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds does not contain all given TypeName elements.
   */
  public S hasLowerBounds(TypeName... lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (lowerBounds == null) failWithMessage("Expecting lowerBounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.lowerBounds, lowerBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds contains the given TypeName elements in Collection.
   * @param lowerBounds the given elements that should be contained in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds does not contain all given TypeName elements.
   */
  public S hasLowerBounds(java.util.Collection<? extends TypeName> lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (lowerBounds == null) {
      failWithMessage("Expecting lowerBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.lowerBounds, lowerBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param lowerBounds the given elements that should be contained in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds does not contain all given TypeName elements.
   */
  public S hasOnlyLowerBounds(TypeName... lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (lowerBounds == null) failWithMessage("Expecting lowerBounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.lowerBounds, lowerBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param lowerBounds the given elements that should be contained in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds does not contain all given TypeName elements.
   */
  public S hasOnlyLowerBounds(java.util.Collection<? extends TypeName> lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (lowerBounds == null) {
      failWithMessage("Expecting lowerBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.lowerBounds, lowerBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds does not contain the given TypeName elements.
   *
   * @param lowerBounds the given elements that should not be in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds contains any given TypeName elements.
   */
  public S doesNotHaveLowerBounds(TypeName... lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (lowerBounds == null) failWithMessage("Expecting lowerBounds parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.lowerBounds, lowerBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's lowerBounds does not contain the given TypeName elements in Collection.
   *
   * @param lowerBounds the given elements that should not be in actual WildcardTypeName's lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds contains any given TypeName elements.
   */
  public S doesNotHaveLowerBounds(java.util.Collection<? extends TypeName> lowerBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (lowerBounds == null) {
      failWithMessage("Expecting lowerBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.lowerBounds, lowerBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName has no lowerBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's lowerBounds is not empty.
   */
  public S hasNoLowerBounds() {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have lowerBounds but had :\n  <%s>";

    // check
    if (actual.lowerBounds.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.lowerBounds);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual WildcardTypeName's upperBounds contains the given TypeName elements.
   * @param upperBounds the given elements that should be contained in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds does not contain all given TypeName elements.
   */
  public S hasUpperBounds(TypeName... upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (upperBounds == null) failWithMessage("Expecting upperBounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.upperBounds, upperBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's upperBounds contains the given TypeName elements in Collection.
   * @param upperBounds the given elements that should be contained in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds does not contain all given TypeName elements.
   */
  public S hasUpperBounds(java.util.Collection<? extends TypeName> upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (upperBounds == null) {
      failWithMessage("Expecting upperBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.upperBounds, upperBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's upperBounds contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param upperBounds the given elements that should be contained in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds does not contain all given TypeName elements.
   */
  public S hasOnlyUpperBounds(TypeName... upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (upperBounds == null) failWithMessage("Expecting upperBounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.upperBounds, upperBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's upperBounds contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param upperBounds the given elements that should be contained in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds does not contain all given TypeName elements.
   */
  public S hasOnlyUpperBounds(java.util.Collection<? extends TypeName> upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (upperBounds == null) {
      failWithMessage("Expecting upperBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.upperBounds, upperBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's upperBounds does not contain the given TypeName elements.
   *
   * @param upperBounds the given elements that should not be in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds contains any given TypeName elements.
   */
  public S doesNotHaveUpperBounds(TypeName... upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (upperBounds == null) failWithMessage("Expecting upperBounds parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.upperBounds, upperBounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName's upperBounds does not contain the given TypeName elements in Collection.
   *
   * @param upperBounds the given elements that should not be in actual WildcardTypeName's upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds contains any given TypeName elements.
   */
  public S doesNotHaveUpperBounds(java.util.Collection<? extends TypeName> upperBounds) {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (upperBounds == null) {
      failWithMessage("Expecting upperBounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.upperBounds, upperBounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WildcardTypeName has no upperBounds.
   * @return this assertion object.
   * @throws AssertionError if the actual WildcardTypeName's upperBounds is not empty.
   */
  public S hasNoUpperBounds() {
    // check that actual WildcardTypeName we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have upperBounds but had :\n  <%s>";

    // check
    if (actual.upperBounds.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.upperBounds);
    }

    // return the current assertion for method chaining
    return myself;
  }


}
