package com.squareup.javapoet;

import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TypeVariableName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractTypeVariableNameAssert<S extends AbstractTypeVariableNameAssert<S, A>, A extends TypeVariableName> extends AbstractTypeNameAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypeVariableNameAssert}</code> to make assertions on actual TypeVariableName.
   * @param actual the TypeVariableName we want to make assertions on.
   */
  protected AbstractTypeVariableNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TypeVariableName's bounds contains the given TypeName elements.
   * @param bounds the given elements that should be contained in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds does not contain all given TypeName elements.
   */
  public S hasBounds(TypeName... bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (bounds == null) failWithMessage("Expecting bounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.bounds, bounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName's bounds contains the given TypeName elements in Collection.
   * @param bounds the given elements that should be contained in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds does not contain all given TypeName elements.
   */
  public S hasBounds(java.util.Collection<? extends TypeName> bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (bounds == null) {
      failWithMessage("Expecting bounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.bounds, bounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName's bounds contains <b>only</b> the given TypeName elements and nothing else in whatever order.
   * @param bounds the given elements that should be contained in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds does not contain all given TypeName elements.
   */
  public S hasOnlyBounds(TypeName... bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (bounds == null) failWithMessage("Expecting bounds parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.bounds, bounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName's bounds contains <b>only</b> the given TypeName elements in Collection and nothing else in whatever order.
   * @param bounds the given elements that should be contained in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds does not contain all given TypeName elements.
   */
  public S hasOnlyBounds(java.util.Collection<? extends TypeName> bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (bounds == null) {
      failWithMessage("Expecting bounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.bounds, bounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName's bounds does not contain the given TypeName elements.
   *
   * @param bounds the given elements that should not be in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds contains any given TypeName elements.
   */
  public S doesNotHaveBounds(TypeName... bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName varargs is not null.
    if (bounds == null) failWithMessage("Expecting bounds parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.bounds, bounds);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName's bounds does not contain the given TypeName elements in Collection.
   *
   * @param bounds the given elements that should not be in actual TypeVariableName's bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds contains any given TypeName elements.
   */
  public S doesNotHaveBounds(java.util.Collection<? extends TypeName> bounds) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // check that given TypeName collection is not null.
    if (bounds == null) {
      failWithMessage("Expecting bounds parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.bounds, bounds.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeVariableName has no bounds.
   * @return this assertion object.
   * @throws AssertionError if the actual TypeVariableName's bounds is not empty.
   */
  public S hasNoBounds() {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have bounds but had :\n  <%s>";

    // check
    if (actual.bounds.iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.bounds);
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual TypeVariableName's name is equal to the given one.
   * @param name the given name to compare the actual TypeVariableName's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeVariableName's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual TypeVariableName we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.name;
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
