/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

public abstract class AbstractTypeNameAssert<S extends AbstractTypeNameAssert<S, A>, A extends TypeName>
extends AbstractObjectAssert<S, A> {
    protected AbstractTypeNameAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S isAnnotated() {
        this.isNotNull();
        if (!((TypeName)this.actual).isAnnotated()) {
            this.failWithMessage("\nExpecting that actual TypeName is annotated but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S isNotAnnotated() {
        this.isNotNull();
        if (((TypeName)this.actual).isAnnotated()) {
            this.failWithMessage("\nExpecting that actual TypeName is not annotated but is.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S isBoxedPrimitive() {
        this.isNotNull();
        if (!((TypeName)this.actual).isBoxedPrimitive()) {
            this.failWithMessage("\nExpecting that actual TypeName is boxed primitive but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S isNotBoxedPrimitive() {
        this.isNotNull();
        if (((TypeName)this.actual).isBoxedPrimitive()) {
            this.failWithMessage("\nExpecting that actual TypeName is not boxed primitive but is.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S isPrimitive() {
        this.isNotNull();
        if (!((TypeName)this.actual).isPrimitive()) {
            this.failWithMessage("\nExpecting that actual TypeName is primitive but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S isNotPrimitive() {
        this.isNotNull();
        if (((TypeName)this.actual).isPrimitive()) {
            this.failWithMessage("\nExpecting that actual TypeName is not primitive but is.", new Object[0]);
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S hasAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S hasAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeNameAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S hasOnlyAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S hasOnlyAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeNameAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S doesNotHaveAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S doesNotHaveAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeNameAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeName)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }

    public S hasNoAnnotations() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";
        if (((TypeName)this.actual).annotations.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeName)this.actual).annotations});
        }
        return (S)((Object)((AbstractTypeNameAssert)this.myself));
    }
}

