/*
 * Decompiled with CFR 0.152.
 */
package org.raml.utilities;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class IndentedAppendable
implements Appendable {
    private static final String END_OF_LINE = System.lineSeparator();
    private final String indent;
    private final Appendable appendable;
    private String currentIndent = "";

    private IndentedAppendable(String indent, Appendable appendable) {
        this.indent = indent;
        this.appendable = appendable;
    }

    public static IndentedAppendable forNoSpaces(int noSpaces, Appendable appendable) {
        Preconditions.checkArgument((noSpaces >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)appendable);
        return new IndentedAppendable(Strings.repeat((String)" ", (int)noSpaces), appendable);
    }

    public void indent() {
        this.currentIndent = this.currentIndent + this.indent;
    }

    public void outdent() {
        Preconditions.checkState((!this.currentIndent.isEmpty() ? 1 : 0) != 0, (Object)"outdenting one too many times");
        this.currentIndent = this.currentIndent.substring(0, this.currentIndent.length() - this.indent.length());
    }

    public IndentedAppendable withIndent() throws IOException {
        this.appendable.append(this.currentIndent);
        return this;
    }

    public IndentedAppendable appendLine(String content) throws IOException {
        this.appendable.append(this.currentIndent).append(content).append("\n");
        return this;
    }

    @Override
    public IndentedAppendable append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public IndentedAppendable append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public IndentedAppendable append(char c) throws IOException {
        this.appendable.append(c);
        return this;
    }

    public IndentedAppendable endOfLine() throws IOException {
        this.appendable.append(END_OF_LINE);
        return this;
    }

    public String toString() {
        return this.appendable.toString();
    }
}

