/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.RamlParsingContextType;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeUtils;

public class ArrayRule
extends Rule {
    private Rule of;

    public ArrayRule(Rule of) {
        this.of = of;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        List<Suggestion> suggestions = this.of.getSuggestions(node, context);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Suggestion suggestion : suggestions) {
            if (node instanceof ArrayNode && !((ArrayNode)node).isJsonStyle()) {
                result.add(suggestion);
                continue;
            }
            if (context.getContextType() == RamlParsingContextType.VALUE) {
                String prefix = "\n" + NodeUtils.computeColumnForChild(node.getParent());
                result.add(suggestion.withValue("- " + suggestion.getValue()).withPrefix(prefix));
                continue;
            }
            result.add(suggestion.withValue("- " + suggestion.getValue()));
        }
        return result;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        if (pathToRoot.isEmpty()) {
            return Collections.emptyList();
        }
        Node mappingNode = pathToRoot.get(0);
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(mappingNode, context);
            }
        }
        return this.of.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof ArrayNode;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.Array);
        }
        Node result = this.createNodeUsingFactory(node, new Object[0]);
        List<Node> children = node.getChildren();
        for (Node child : children) {
            if (this.of.matches(child)) {
                Node transform = this.of.apply(child);
                child.replaceWith(transform);
                continue;
            }
            child.replaceWith(ErrorNodeFactory.createInvalidArrayElement(child));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Array[" + this.of.getDescription() + "]";
    }
}

