/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeSelector;

public class FieldPresentRule
extends Rule {
    private String selector;
    private Rule delegate;

    public FieldPresentRule(String selector, Rule then) {
        this.selector = selector;
        this.delegate = then;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return this.delegate.getSuggestions(node, context);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return this.isPresent(node) && this.delegate.matches(node);
    }

    private boolean isPresent(@Nonnull Node node) {
        return NodeSelector.selectFrom(this.selector, node) != null;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.isPresent(node)) {
            return this.delegate.apply(node);
        }
        return ErrorNodeFactory.createMissingField(this.selector);
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }
}

