/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class MinPropertiesRule
extends Rule {
    private int minProperties;

    public MinPropertiesRule(int minProperties) {
        this.minProperties = minProperties;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node.getChildren().size() > this.minProperties;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((StringNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidMinProperties(this.minProperties);
    }

    @Override
    public String getDescription() {
        return "Min amount of properties " + this.minProperties;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }
}

