/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.AbstractTypeRule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class NumberTypeRule
extends AbstractTypeRule {
    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof FloatingNode || node instanceof IntegerNode) {
            return true;
        }
        if (node instanceof StringNode) {
            try {
                Double.parseDouble(((StringNode)node).getValue());
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Number";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Float;
    }
}

