/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class RangeValueRule
extends Rule {
    private Number maximumValue;
    private Number minimumValue;

    public RangeValueRule(Number minimumValue, Number maximumValue) {
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            return ((IntegerNode)node).getValue().compareTo(this.minimumValue.intValue()) >= 0 && ((IntegerNode)node).getValue().compareTo(this.maximumValue.intValue()) <= 0;
        }
        return node instanceof FloatingNode && ((FloatingNode)node).getValue().compareTo(new BigDecimal(this.minimumValue.intValue())) >= 0 && ((FloatingNode)node).getValue().compareTo(new BigDecimal(this.maximumValue.intValue())) <= 0;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidRangeValue(this.minimumValue, this.maximumValue);
    }

    @Override
    public String getDescription() {
        return "Maximum value";
    }
}

