/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public abstract class BaseNode
implements Node {
    private Node source;
    private Node parent;
    protected List<Node> children = new ArrayList<Node>();

    public BaseNode() {
    }

    public BaseNode(BaseNode node) {
        this.source = node;
        for (Node child : node.children) {
            this.addChild(child.copy());
        }
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public List<Node> getChildren() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.children));
    }

    @Override
    public void addChild(Node node) {
        node.setParent(this);
        this.children.add(node);
    }

    @Override
    public void removeChild(Node node) {
        node.setParent(null);
        this.children.remove(node);
    }

    @Override
    public Node getRootNode() {
        return this.getParent() == null ? this : this.getParent().getRootNode();
    }

    @Override
    @Nonnull
    public <T extends Node> List<T> findDescendantsWith(Class<T> nodeType) {
        ArrayList<T> result = new ArrayList<T>();
        List<Node> children = this.getChildren();
        for (Node child : children) {
            if (nodeType.isAssignableFrom(child.getClass())) {
                result.add(nodeType.cast(child));
            }
            result.addAll(child.findDescendantsWith(nodeType));
        }
        return result;
    }

    @Override
    @Nullable
    public <T extends Node> T findAncestorWith(Class<T> nodeType) {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!nodeType.isAssignableFrom(parent.getClass())) continue;
            return (T)((Node)nodeType.cast(parent));
        }
        return null;
    }

    @Override
    public void replaceWith(Node newNode) {
        if (this != newNode) {
            if (this.getParent() != null) {
                int idx = this.getParent().getChildren().indexOf(this);
                this.getParent().setChild(idx, newNode);
            }
            newNode.setSource(this);
            for (Node child : this.getChildren()) {
                newNode.addChild(child);
            }
        }
    }

    @Override
    public void removeChildren() {
        for (Node child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public void setChild(int idx, Node newNode) {
        this.children.set(idx, newNode);
        newNode.setParent(this);
    }

    @Override
    public void addChild(int idx, Node newNode) {
        this.children.add(idx, newNode);
        newNode.setParent(this);
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public void setSource(Node source) {
        this.source = source;
    }

    @Override
    public Node getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public Node get(String selector) {
        return NodeSelector.selectFrom(selector, (Node)this);
    }
}

