/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.InputStream;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class ClassPathResourceLoader
implements ResourceLoaderExtended {
    @Override
    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        }
        if (callback != null && inputStream != null) {
            try {
                callback.onResourceFound(Thread.currentThread().getContextClassLoader().getResource(resourceName).toURI());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        return inputStream;
    }

    @Override
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }
}

