/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.model;

import org.raml.yagi.framework.nodes.BooleanNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeUtils;

public enum SimpleValueTransformer {
    STRING{

        @Override
        public boolean accepts(Class<?> type) {
            return String.class.isAssignableFrom(type);
        }

        @Override
        public String adaptTo(Node valueNode, Class<?> returnType) {
            if (NodeUtils.isNull(valueNode)) {
                return null;
            }
            if (valueNode instanceof SimpleTypeNode) {
                return ((SimpleTypeNode)valueNode).getLiteralValue();
            }
            throw new RuntimeException("Invalid node type " + (Object)((Object)valueNode.getType()) + " expecting a simple type.");
        }
    }
    ,
    BOOLEAN{

        @Override
        public boolean accepts(Class<?> type) {
            return Boolean.class.isAssignableFrom(type) || Boolean.TYPE.equals(type);
        }

        @Override
        public Boolean adaptTo(Node valueNode, Class<?> returnType) {
            if (NodeUtils.isNull(valueNode)) {
                return null;
            }
            if (valueNode instanceof BooleanNode) {
                return ((BooleanNode)valueNode).getValue();
            }
            if (valueNode instanceof SimpleTypeNode) {
                return Boolean.parseBoolean(((SimpleTypeNode)valueNode).getLiteralValue());
            }
            throw new RuntimeException("Invalid node type " + (Object)((Object)valueNode.getType()) + " expecting a simple type.");
        }
    }
    ,
    INT{

        @Override
        public boolean accepts(Class<?> type) {
            return Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type);
        }

        @Override
        public Integer adaptTo(Node valueNode, Class<?> returnType) {
            if (NodeUtils.isNull(valueNode)) {
                return null;
            }
            if (valueNode instanceof IntegerNode) {
                return ((IntegerNode)valueNode).getValue();
            }
            if (valueNode instanceof SimpleTypeNode) {
                return Integer.parseInt(((SimpleTypeNode)valueNode).getLiteralValue());
            }
            throw new RuntimeException("Invalid node type " + (Object)((Object)valueNode.getType()) + " expecting a simple type.");
        }
    }
    ,
    FLOAT{

        @Override
        public boolean accepts(Class<?> type) {
            return Float.class.isAssignableFrom(type) || Float.TYPE.equals(type);
        }

        @Override
        public Float adaptTo(Node valueNode, Class<?> returnType) {
            if (NodeUtils.isNull(valueNode)) {
                return null;
            }
            if (valueNode instanceof SimpleTypeNode) {
                return Float.valueOf(Float.parseFloat(((SimpleTypeNode)valueNode).getLiteralValue()));
            }
            throw new RuntimeException("Invalid node type " + (Object)((Object)valueNode.getType()) + " expecting a simple type.");
        }
    }
    ,
    ENUM{

        @Override
        public boolean accepts(Class<?> type) {
            return type.isEnum();
        }

        @Override
        public Object adaptTo(Node valueNode, Class<?> returnType) {
            if (NodeUtils.isNull(valueNode)) {
                return null;
            }
            if (valueNode instanceof SimpleTypeNode) {
                String literalValue = ((SimpleTypeNode)valueNode).getLiteralValue();
                return Enum.valueOf(returnType, literalValue);
            }
            throw new RuntimeException("Invalid node type " + (Object)((Object)valueNode.getType()) + " expecting a simple type.");
        }
    };


    public abstract Object adaptTo(Node var1, Class<?> var2);

    public abstract boolean accepts(Class<?> var1);
}

