/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes;

import javax.annotation.Nonnull;
import org.raml.yagi.framework.nodes.BaseNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.Position;

public class KeyValueNodeImpl
extends BaseNode
implements KeyValueNode {
    private Position startPosition;
    private Position endPosition;

    public KeyValueNodeImpl() {
    }

    public KeyValueNodeImpl(@Nonnull Node keyNode, @Nonnull Node valueNode) {
        this.addChild(keyNode);
        this.addChild(valueNode);
    }

    public KeyValueNodeImpl(KeyValueNodeImpl node) {
        super(node);
    }

    @Override
    @Nonnull
    public Position getStartPosition() {
        if (this.startPosition == null) {
            if (this.getChildren().size() != 2) {
                return DefaultPosition.emptyPosition();
            }
            return this.getChildren().get(0).getStartPosition();
        }
        return this.startPosition;
    }

    @Override
    @Nonnull
    public Position getEndPosition() {
        if (this.endPosition == null) {
            if (this.getChildren().size() != 2) {
                return DefaultPosition.emptyPosition();
            }
            return this.getValue().getEndPosition();
        }
        return this.endPosition;
    }

    public void setStartPosition(Position startPosition) {
        this.startPosition = startPosition;
    }

    public void setEndPosition(Position endPosition) {
        this.endPosition = endPosition;
    }

    @Override
    public void addChild(Node node) {
        if (this.getChildren().size() >= 2) {
            throw new IllegalStateException("Can not add '" + node + "' to " + this + " node it already has hey and value.");
        }
        super.addChild(node);
    }

    @Override
    @Nonnull
    public Node copy() {
        return new KeyValueNodeImpl(this);
    }

    @Override
    public Node getKey() {
        if (this.getChildren().isEmpty()) {
            throw new IllegalStateException("Key value pair with no key " + this.getClass().getSimpleName());
        }
        return this.getChildren().get(0);
    }

    @Override
    public Node getValue() {
        if (this.getChildren().size() < 2) {
            throw new IllegalStateException("Key value pair with no value " + this.getClass().getSimpleName());
        }
        return this.getChildren().get(1);
    }

    @Override
    public void setValue(Node valueNode) {
        this.setChild(1, valueNode);
    }

    public String toString() {
        return String.format("%s: %s", this.getKey(), this.getValue());
    }

    @Override
    public NodeType getType() {
        return NodeType.KeyValue;
    }
}

