/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class ClassPathResourceLoader
implements ResourceLoaderExtended {
    private final String rootRamlPackage;
    private URI callbackParam;

    public ClassPathResourceLoader() {
        this.rootRamlPackage = "";
    }

    public ClassPathResourceLoader(String rootRamlPackage) {
        this.rootRamlPackage = StringUtils.isBlank((String)rootRamlPackage) || rootRamlPackage.equals("/") ? "" : (rootRamlPackage.startsWith("/") ? rootRamlPackage.substring(1) : rootRamlPackage) + "/";
    }

    private URL getResource(String uselessRootPackage, String resourceName) {
        String fixedResourceName = uselessRootPackage + (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        URL url = this.getClass().getClassLoader().getResource(fixedResourceName);
        if (url == null) {
            return Thread.currentThread().getContextClassLoader().getResource(fixedResourceName);
        }
        return url;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        try {
            URL url = this.getResource(this.rootRamlPackage, resourceName);
            if (url != null) {
                this.callbackParam = url.toURI();
                if (callback != null) {
                    callback.onResourceFound(this.callbackParam);
                }
                return url.openStream();
            }
            return null;
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    @Override
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam() {
        return this.callbackParam;
    }
}

