/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.File;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderFactory;
import org.raml.v2.api.loader.RootRamlFileResourceLoader;
import org.raml.v2.api.loader.RootRamlUrlResourceLoader;

public class ResourceLoaderFactories {
    public static ResourceLoaderFactory identityFactory(final ResourceLoader loader) {
        return new ResourceLoaderFactory(){

            @Override
            public ResourceLoader createResourceLoader(String parent) {
                return loader;
            }
        };
    }

    public static ResourceLoaderFactory nullFactory() {
        return new ResourceLoaderFactory(){

            @Override
            public ResourceLoader createResourceLoader(String parent) {
                return new ResourceLoader(){

                    @Override
                    @Nullable
                    public InputStream fetchResource(String resourceName) {
                        return null;
                    }
                };
            }
        };
    }

    public static ResourceLoaderFactory defaultResourceLoaderFactory() {
        return new ResourceLoaderFactory(){

            @Override
            public ResourceLoader createResourceLoader(String parent) {
                return CompositeResourceLoader.compose(new DefaultResourceLoader(), new RootRamlFileResourceLoader(new File(parent)), new RootRamlUrlResourceLoader(parent));
            }
        };
    }
}

