/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class DivisorValueRule
extends Rule {
    private final boolean castStringsAsNumbers;
    private Number divisorValue;

    public DivisorValueRule(Number divisorValue) {
        this.divisorValue = divisorValue;
        this.castStringsAsNumbers = false;
    }

    public DivisorValueRule(Number multiple, boolean castStringsAsNumbers) {
        this.divisorValue = multiple;
        this.castStringsAsNumbers = castStringsAsNumbers;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        BigDecimal divisor = new BigDecimal(this.divisorValue.toString());
        BigDecimal value = null;
        if (node instanceof StringNode && this.castStringsAsNumbers) {
            String intString = ((StringNode)node).getValue();
            try {
                value = new BigDecimal(intString);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (node instanceof IntegerNode) {
            value = new BigDecimal(((IntegerNode)node).getValue());
        } else if (node instanceof FloatingNode) {
            value = ((FloatingNode)node).getValue();
        }
        if (value != null) {
            if (divisor.compareTo(BigDecimal.ZERO) == 0 && value.compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            return divisor.compareTo(BigDecimal.ZERO) != 0 && value.remainder(divisor).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        if (node instanceof IntegerNode && this.divisorValue.intValue() == 0 || node instanceof FloatingNode && this.divisorValue.floatValue() == 0.0f) {
            return ErrorNodeFactory.createInvalidDivisorValue();
        }
        return ErrorNodeFactory.createInvalidMultipleOfValue(this.divisorValue);
    }

    @Override
    public String getDescription() {
        return "Multiple of value";
    }
}

