/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class RootRamlUrlResourceLoader
implements ResourceLoaderExtended {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    private String rootRamlUrl;
    private URI callbackParam;

    public RootRamlUrlResourceLoader(String rootRamlUrl) {
        this.rootRamlUrl = rootRamlUrl.endsWith("/") ? rootRamlUrl : rootRamlUrl + "/";
    }

    @Override
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        try {
            URL url = new URL(resourceName.startsWith(this.rootRamlUrl) ? resourceName : this.rootRamlUrl + resourceName);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Accept", "application/raml+yaml, */*");
            if (callback != null) {
                this.callbackParam = url.toURI();
                callback.onResourceFound(this.callbackParam);
            }
            return new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam() {
        return this.callbackParam;
    }
}

