/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.AbstractTypeRule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class NumberTypeRule
extends AbstractTypeRule {
    private final boolean castStringsAsNumbers;
    @Nullable
    private Range<Double> range;

    public NumberTypeRule(@Nullable Range<Double> range) {
        this.range = range;
        this.castStringsAsNumbers = false;
    }

    public NumberTypeRule() {
        this(null);
    }

    public NumberTypeRule(boolean castStringsAsNumbers) {
        this.castStringsAsNumbers = castStringsAsNumbers;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof StringNode && this.castStringsAsNumbers) {
            String intString = ((StringNode)node).getValue();
            try {
                double doubleValue = Double.parseDouble(intString);
                return this.range == null || this.range.contains((Comparable)Double.valueOf(doubleValue));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (node instanceof FloatingNode) {
            return this.range == null || this.range.contains((Comparable)Double.valueOf(((FloatingNode)node).getValue().doubleValue()));
        }
        if (node instanceof IntegerNode) {
            return this.range == null || this.range.contains((Comparable)Double.valueOf(((IntegerNode)node).getValue().doubleValue()));
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Number";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Float;
    }
}

