/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.app.GenericGUI;
import org.rapidoid.app.Scripting;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.data.JSON;
import org.rapidoid.dispatch.DispatchResult;
import org.rapidoid.dispatch.PojoDispatchException;
import org.rapidoid.dispatch.PojoDispatcher;
import org.rapidoid.dispatch.PojoHandlerNotFoundException;
import org.rapidoid.dispatch.PojoRequest;
import org.rapidoid.dispatch.impl.DispatchReqKind;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.io.Res;
import org.rapidoid.plugins.templates.Templates;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.webapp.AppCtx;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.webapp.WebEventReq;
import org.rapidoid.webapp.WebReq;

public class AppHandler
implements Handler {
    private static final String PAGE_RELOAD = "<h2>&nbsp;Reloading...</h2><script>location.reload();</script>";
    private static final Pattern DIRECTIVE = Pattern.compile("\\s*<!--\\s*#\\s*(\\{.+\\})\\s*-->\\s*");

    public Object handle(HttpExchange x) throws Exception {
        return this.dispatch((HttpExchangeImpl)x);
    }

    private Object dispatch(HttpExchangeImpl x) {
        DispatchResult dres;
        if (x.isGetReq() && x.serveStaticFile()) {
            return x;
        }
        WebApp app = AppCtx.app();
        PojoDispatcher dispatcher = app.getDispatcher();
        x.loadState();
        boolean hasEvent = x.isPostReq() && !U.isEmpty((Object)x.data("_event", null));
        Object result = null;
        if (hasEvent) {
            this.bindInputs(x);
            DispatchResult dispatchResult = this.doDispatch(dispatcher, (PojoRequest)new WebReq((HttpExchange)x));
            if (dispatchResult != null) {
                U.must((dispatchResult.getKind() == DispatchReqKind.PAGE ? 1 : 0) != 0);
                result = dispatchResult.getResult();
            }
            if (x.hasErrors()) {
                x.json();
                return U.map((Object)"!errors", (Object)x.errors());
            }
        }
        Map config = null;
        if (result == null && (dres = this.doDispatch(dispatcher, (PojoRequest)new WebReq((HttpExchange)x))) != null) {
            result = dres.getResult();
            config = dres.getConfig();
            if (dres.getKind() == DispatchReqKind.SERVICE) {
                x.json();
                return result;
            }
        }
        if (config == null) {
            config = U.map();
        }
        if (result == null && Scripting.runDynamicScript(x, hasEvent, config)) {
            return x;
        }
        if (result == null) {
            result = GenericGUI.genericScreen();
        }
        return AppHandler.view((HttpExchange)x, result, hasEvent, config);
    }

    private void bindInputs(HttpExchangeImpl x) {
        Map inputs = (Map)x.data("_inputs", null);
        if (inputs != null) {
            for (Map.Entry e : inputs.entrySet()) {
                String inputId = (String)e.getKey();
                Object value = e.getValue();
                x.locals().put(inputId, UTILS.serializable(value));
            }
        }
    }

    public static Object view(HttpExchange x, Object result, boolean hasEvent, Map<String, Object> config) {
        if (Cls.bool((Object)config.get("raw"))) {
            x.html();
            return result;
        }
        if (AppHandler.serveDynamicPage(x, result, hasEvent, config)) {
            return x;
        }
        if (result != null) {
            x.result(result);
            return x;
        }
        throw x.notFound();
    }

    private DispatchResult doDispatch(PojoDispatcher dispatcher, PojoRequest req) {
        try {
            return dispatcher.dispatch(req);
        }
        catch (PojoHandlerNotFoundException e) {
            return null;
        }
        catch (PojoDispatchException e) {
            throw U.rte((String)"Dispatch error!", (Throwable)e);
        }
    }

    public static boolean serveDynamicPage(HttpExchange x, Object result, boolean hasEvent, Map<String, Object> config) {
        String filename = x.name() + ".html";
        String firstFile = Conf.rootPath() + "/pages/" + filename;
        String defaultFile = Conf.rootPathDefault() + "/pages/" + filename;
        Res res = Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile, defaultFile});
        Map model = (Map)U.cast((Object)U.map((Object)"login", (Object)true, (Object)"profile", (Object)true));
        if (res.exists()) {
            model.putAll(AppHandler.generatePageContent(x, result, res));
        } else if (result != null) {
            model.put("result", result);
            model.put("content", result);
        } else {
            return false;
        }
        WebApp app = AppCtx.app();
        String title = (String)U.or((Object)app.getTitle(), (Object)x.host());
        model.put("title", title);
        model.put("embedded", hasEvent || x.param("_embedded", null) != null);
        if (config != null) {
            model.putAll(config);
        }
        if (!Cls.bool(model.get("navbar"))) {
            model.put("navbar", !U.isEmpty(model.get("title")));
        }
        if (hasEvent && x.param("_embedded", null) == null) {
            AppHandler.serveEventResponse((HttpExchangeImpl)x, x.renderPageToHTML((Object)model));
        } else {
            x.renderPage((Object)model);
        }
        return true;
    }

    private static void serveEventResponse(HttpExchangeImpl x, String html) {
        x.startResponse(200);
        x.json();
        if (x.redirectUrl() != null) {
            x.writeJSON((Object)U.map((Object)"_redirect_", (Object)x.redirectUrl()));
        } else {
            Map sel = U.map((Object)"body", (Object)html);
            x.writeJSON((Object)U.map((Object)"_sel_", (Object)sel, (Object)"_state_", (Object)x.serializeLocals()));
        }
    }

    private static Map<String, Object> generatePageContent(HttpExchange x, Object result, Res resource) {
        String line;
        Matcher m;
        String template = U.safe((String)resource.getContent());
        Map model = x.model();
        model.put("result", result);
        String[] contentParts = template.split("\n", 2);
        if (contentParts.length == 2 && (m = DIRECTIVE.matcher(line = contentParts[0])).matches()) {
            Map directives = JSON.parseMap((String)m.group(1));
            model.putAll(directives);
            template = contentParts[1];
        }
        String content = Templates.fromString((String)template).render(new Object[]{result, model});
        model.put("content", content);
        return model;
    }

    public DispatchResult on(HttpExchange x, PojoDispatcher dispatcher, String event, Object[] args) {
        Map state = (Map)U.cast((Object)x.locals());
        WebEventReq req = new WebEventReq(x.path(), event.toUpperCase(), args, state);
        return this.doDispatch(dispatcher, (PojoRequest)req);
    }

    public static final void reload(HttpExchange x) {
        Map sel = U.map((Object)"body", (Object)PAGE_RELOAD);
        x.writeJSON((Object)U.map((Object)"_sel_", (Object)sel));
    }
}

