/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Map;
import java.util.Set;
import org.rapidoid.annotation.App;
import org.rapidoid.annotation.Transaction;
import org.rapidoid.annotation.Web;
import org.rapidoid.aop.AOP;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.app.AppClasses;
import org.rapidoid.app.AsyncAppHandler;
import org.rapidoid.app.TransactionInterceptor;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpBuiltins;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.WebServer;
import org.rapidoid.log.Log;
import org.rapidoid.oauth.OAuth;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.plugins.db.DBPlugin;
import org.rapidoid.plugins.entities.EntitiesPlugin;
import org.rapidoid.plugins.languages.LanguagesPlugin;
import org.rapidoid.plugins.lifecycle.Lifecycle;
import org.rapidoid.plugins.lifecycle.LifecyclePlugin;
import org.rapidoid.plugins.templates.MustacheTemplatesPlugin;
import org.rapidoid.plugins.users.UsersPlugin;
import org.rapidoid.util.U;
import org.rapidoid.util.Usage;
import org.rapidoid.webapp.Scan;
import org.rapidoid.webapp.WebApp;

public class Apps {
    private static final String BUILT_IN_SCREEN_SUFFIX = "BuiltIn";

    public static void run(WebApp app, String[] args, Object ... config) {
        Apps.bootstrap(app, args, config);
        Apps.serve(app, args, config);
    }

    public static void bootstrap(WebApp app, String[] args, Object ... config) {
        Set configArgs = U.set((Object[])args);
        for (Object arg : config) {
            Apps.processArg(configArgs, arg);
        }
        Object[] configArgsArr = configArgs.toArray(new String[configArgs.size()]);
        Conf.args((String[])configArgsArr);
        Log.args((String[])configArgsArr);
        Plugins.register((Plugin)new MustacheTemplatesPlugin());
        AOP.intercept((AOPInterceptor)new TransactionInterceptor(), (Class[])new Class[]{Transaction.class});
        Lifecycle.onStart((Object[])configArgsArr);
    }

    public static HTTPServer serve(WebApp app, String[] args, Object ... config) {
        HTTPServer server = WebServer.build();
        OAuth.register((WebApp)app, (OAuthProvider[])new OAuthProvider[0]);
        HttpBuiltins.register((WebApp)app);
        app.getRouter().serve((Handler)new AsyncAppHandler());
        return server.start();
    }

    private static void processArg(Set<String> config, Object arg) {
        Log.info((String)"Processing start-up argument", (String)"arg", (Object)arg);
        if (arg instanceof String) {
            config.add((String)arg);
        } else if (arg instanceof DBPlugin) {
            Plugins.register((Plugin)((DBPlugin)arg));
        } else if (arg instanceof EntitiesPlugin) {
            Plugins.register((Plugin)((EntitiesPlugin)arg));
        } else if (arg instanceof LanguagesPlugin) {
            Plugins.register((Plugin)((LanguagesPlugin)arg));
        } else if (arg instanceof LifecyclePlugin) {
            Plugins.register((Plugin)((LifecyclePlugin)arg));
        } else if (arg instanceof UsersPlugin) {
            Plugins.register((Plugin)((UsersPlugin)arg));
        }
    }

    public static String screenName(Class<?> screenClass) {
        String name = screenClass.getSimpleName();
        name = U.trimr((String)name, (String)BUILT_IN_SCREEN_SUFFIX);
        name = U.trimr((String)name, (String)"Screen");
        return name;
    }

    public static String screenUrl(Class<?> screenClass) {
        String url = "/" + Apps.screenName(screenClass).toLowerCase();
        return url.equals("/home") ? "/" : url;
    }

    public static AppClasses scanAppClasses(HttpExchange x) {
        return Apps.scanAppClasses(x, null);
    }

    public static AppClasses scanAppClasses(HttpExchange x, ClassLoader classLoader) {
        Map apps = Cls.classMap((Iterable)Scan.annotated(App.class, (ClassLoader)classLoader));
        Map services = Cls.classMap((Iterable)Scan.annotated(Web.class, (ClassLoader)classLoader));
        Class appClass = !apps.isEmpty() ? (Class)apps.values().iterator().next() : null;
        return new AppClasses(appClass, services);
    }

    public static AppClasses getAppClasses(HttpExchange x, ClassLoader classLoader) {
        return Apps.scanAppClasses(x, classLoader);
    }

    public static <T> T config(Object obj, String configName, T byDefault) {
        Object val = Beany.getPropValue((Object)obj, (String)configName, null);
        return (T)(val != null ? val : byDefault);
    }

    public static boolean addon(Object obj, String configName) {
        return Apps.config(obj, configName, false) != false || Apps.config(obj, "full", true) != false;
    }

    public static void terminate(final int afterSeconds) {
        Log.warn((String)("Terminating application in " + afterSeconds + " seconds..."));
        new Thread(){

            @Override
            public void run() {
                U.sleep((long)(afterSeconds * 1000));
                Apps.terminate();
            }
        }.start();
    }

    public static void terminateIfIdleFor(final int idleSeconds) {
        Log.warn((String)("Will terminate if idle for " + idleSeconds + " seconds..."));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    U.sleep((long)500L);
                    long lastUsed = Usage.getLastAppUsedOn();
                    long idleSec = (U.time() - lastUsed) / 1000L;
                    if (idleSec < (long)idleSeconds) continue;
                    Usage.touchLastAppUsedOn();
                    Apps.terminate();
                }
            }
        }).start();
    }

    public static void terminate() {
        Log.warn((String)"Terminating application.");
        Lifecycle.onShutdown();
        System.exit(0);
    }

    public static Object instantiate(Class<?> appClass, HttpExchange x) {
        return appClass != null ? Cls.newInstance(appClass) : new Object();
    }
}

