/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.rapidoid.annotation.DELETE;
import org.rapidoid.annotation.GET;
import org.rapidoid.annotation.POST;
import org.rapidoid.annotation.PUT;
import org.rapidoid.plugins.db.DB;
import org.rapidoid.util.U;

public class CRUD<E> {
    private final Class<E> clazz;

    private static Class<?> inferEntityType(Class<? extends CRUD<?>> CRUDClass) {
        U.must((CRUDClass.getSuperclass() == CRUD.class ? 1 : 0) != 0, (String)"Expected CRUD to be superclass of %s, but found: %s!", CRUDClass, CRUDClass.getSuperclass());
        Type type = CRUDClass.getGenericSuperclass();
        ParameterizedType genericCRUD = type instanceof ParameterizedType ? (ParameterizedType)type : null;
        U.must((genericCRUD != null && genericCRUD.getActualTypeArguments().length > 0 ? 1 : 0) != 0, (String)"Cannot infer entity type for: %s", CRUDClass);
        Type arg = genericCRUD.getActualTypeArguments()[0];
        return arg instanceof Class ? (Class)arg : Object.class;
    }

    public CRUD() {
        this.clazz = CRUD.inferEntityType(this.getClass());
    }

    public CRUD(Class<E> clazz) {
        this.clazz = clazz;
    }

    public Class<E> getEntityType() {
        return this.clazz;
    }

    @GET(uri="/get")
    public E get(String id) {
        return (E)DB.get(this.clazz, (String)id);
    }

    @POST(uri="/insert")
    public String insert(E record) {
        return DB.insert(record);
    }

    @POST(uri="/update")
    @PUT
    public void update(String id, E record) {
        DB.update((String)id, record);
    }

    @POST(uri="/delete")
    @DELETE
    public void delete(String id) {
        DB.delete((Object)id);
    }

    @GET(uri="/all")
    public Iterable<E> all() {
        return DB.getAll(this.clazz);
    }

    @GET(uri="/page")
    public Iterable<E> page(int page) {
        return DB.getAll(this.clazz, (int)page, (int)20);
    }
}

