/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.rapidoid.app.AppHandler;
import org.rapidoid.app.Dollar;
import org.rapidoid.app.DollarPage;
import org.rapidoid.app.GUI;
import org.rapidoid.beany.BeanProperties;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.io.Res;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.util.U;
import org.rapidoid.webapp.AppCtx;

public class Scripting {
    public static boolean runDynamicScript(final HttpExchangeImpl x, final boolean hasEvent, final Map<String, Object> config) {
        final CompiledScript script = Scripting.script(x);
        if (script != null) {
            x.async();
            Jobs.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    Scripting.runScript(x, script, hasEvent, config);
                }
            });
            return true;
        }
        return false;
    }

    private static CompiledScript script(HttpExchangeImpl x) {
        String defaultFile;
        String firstFile;
        String scriptName = x.isGetReq() ? x.verbAndResourceName() : x.verb().toUpperCase() + "_" + x.name();
        String filename = scriptName + ".js";
        Res res = Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile = Conf.rootPath() + "/" + filename, defaultFile = Conf.rootPathDefault() + "/" + filename});
        if (!res.exists()) {
            return null;
        }
        CompiledScript compiled = (CompiledScript)res.attachment();
        if (compiled == null) {
            String js = res.getContent();
            try {
                compiled = U.compileJS((String)js);
            }
            catch (ScriptException e) {
                throw U.rte((String)"Script compilation error!", (Throwable)e);
            }
            res.attach((Object)compiled);
        }
        return compiled;
    }

    protected static void runScript(HttpExchangeImpl x, CompiledScript script, boolean hasEvent, Map<String, Object> config) {
        Object result;
        Map bindings = U.map();
        Dollar dollar = new Dollar((HttpExchange)x, bindings);
        for (Map.Entry e : x.data().entrySet()) {
            bindings.put("$" + (String)e.getKey(), e.getValue());
        }
        bindings.put("$", dollar);
        try {
            result = script.eval(new SimpleBindings(bindings));
        }
        catch (Throwable e) {
            Log.error((String)"Script error", (Throwable)e);
            HttpProtocol.handleError((HttpExchangeImpl)x, (Throwable)e);
            return;
        }
        if (result != null && !dollar.hasResult() && Cls.isSimple((Object)result)) {
            dollar.result(result);
        }
    }

    public static void onScriptResult(HttpExchange x, Object result) {
        boolean rendered = Scripting.calcFinalResult(x, result);
        if (!rendered) {
            x.result(result);
        }
        x.done();
    }

    private static boolean calcFinalResult(HttpExchange x, Object result) {
        Map<String, Object> config = U.map();
        if (result == x) {
            result = Scripting.desc(x);
        } else if (result instanceof Dollar) {
            result = Scripting.desc((Dollar)result);
        } else if (result instanceof DollarPage) {
            DollarPage page = (DollarPage)result;
            config = page.getConfig();
            result = page.getValue();
        } else if (result != null) {
            if (Scripting.canDescribe(result)) {
                result = Scripting.descObj(result);
            } else {
                return false;
            }
        }
        AppHandler.view(x, result, false, config);
        return true;
    }

    private static boolean canDescribe(Object obj) {
        return Cls.isBean((Object)obj);
    }

    public static Object desc(HttpExchange x) {
        Map desc = U.map();
        desc.put("verb", x.verb());
        desc.put("uri", x.uri());
        desc.put("path", x.path());
        desc.put("home", x.home());
        desc.put("dev", x.isDevMode());
        boolean loggedIn = AppCtx.isLoggedIn();
        desc.put("loggedIn", loggedIn);
        desc.put("user", loggedIn ? AppCtx.user() : null);
        return GUI.multi((Object[])new Object[]{GUI.h2((Object[])new Object[]{"Request details:"}), GUI.grid((Map)desc), GUI.h2((Object[])new Object[]{"Request params:"}), GUI.grid((Map)x.data()), GUI.h2((Object[])new Object[]{"Cookies:"}), GUI.grid((Map)x.cookies())});
    }

    public static Object desc(Dollar dollar) {
        Map desc = U.map();
        BeanProperties props = Beany.propertiesOf(Dollar.class);
        for (Prop prop : props) {
            Object val = prop.get((Object)dollar);
            desc.put(prop.getName(), val != null ? val.getClass().getSimpleName() : "NULL");
        }
        return GUI.multi((Object[])new Object[]{GUI.h2((Object[])new Object[]{"The $ properties:"}), GUI.grid((Map)desc), GUI.h2((Object[])new Object[]{"Bindings:"}), GUI.grid(dollar.bindings)});
    }

    public static Object descObj(Object obj) {
        Map desc = U.map();
        BeanProperties props = Beany.propertiesOf((Object)obj);
        for (Prop prop : props) {
            desc.put(prop.getName(), prop.getType());
        }
        String title = U.format((String)"Properties of %s:", (Object[])new Object[]{obj.getClass().getSimpleName()});
        return GUI.multi((Object[])new Object[]{GUI.h2((Object[])new Object[]{title}), GUI.grid((Map)desc)});
    }
}

