/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.activity;

import java.util.concurrent.CancellationException;
import org.rapidoid.activity.RapidoidThread;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public abstract class AbstractLoopThread
extends RapidoidThread {
    private volatile long sleepMs = 5L;

    public AbstractLoopThread() {
    }

    public AbstractLoopThread(String name) {
        super(name);
    }

    public AbstractLoopThread(long sleepMs) {
        this.sleepMs = sleepMs;
    }

    @Override
    public final void run() {
        while (!Thread.interrupted()) {
            try {
                this.loop();
                if (this.sleepMs <= 0L) continue;
                U.sleep((long)this.sleepMs);
            }
            catch (ThreadDeath e) {
                Log.error((String)"Received ThreadDeath error, terminating!", (Throwable)e);
                return;
            }
            catch (CancellationException e) {
                Log.info((String)"The thread was interrupted.");
                return;
            }
            catch (Throwable e) {
                Log.error((String)"Exception occurred inside the thread loop!", (Throwable)e);
            }
        }
    }

    protected abstract void loop() throws Exception;
}

