/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class English
extends RapidoidThing {
    private static final Pattern PLURAL1 = Pattern.compile(".*(s|x|z|ch|sh)$");
    private static final Pattern PLURAL1U = Pattern.compile(".*(S|X|Z|CH|SH)$");
    private static final Pattern PLURAL2 = Pattern.compile(".*[bcdfghjklmnpqrstvwxz]o$");
    private static final Pattern PLURAL2U = Pattern.compile(".*[BCDFGHJKLMNPQRSTVWXZ]O$");
    private static final Pattern PLURAL3 = Pattern.compile(".*[bcdfghjklmnpqrstvwxz]y$");
    private static final Pattern PLURAL3U = Pattern.compile(".*[BCDFGHJKLMNPQRSTVWXZ]Y$");
    private static final Map<String, String> IRREGULAR_PLURAL = English.loadIrregularPlural();

    private static Map<String, String> loadIrregularPlural() {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("irregular-plural.txt"));
        }
        catch (IOException e) {
            Log.error((String)"Couldn't load irregular plural!", (Throwable)e);
        }
        return (Map)U.cast((Object)props);
    }

    public static String plural(String noun) {
        if (U.isEmpty((String)noun)) {
            return noun;
        }
        if (IRREGULAR_PLURAL.containsKey(noun.toLowerCase())) {
            boolean capital = Character.isUpperCase(noun.charAt(0));
            boolean upper = Character.isUpperCase(noun.charAt(noun.length() - 1));
            String pl = IRREGULAR_PLURAL.get(noun.toLowerCase());
            if (upper) {
                return pl.toUpperCase();
            }
            return capital ? Str.capitalized(pl) : pl;
        }
        if (PLURAL1.matcher(noun).matches()) {
            return noun + "es";
        }
        if (PLURAL2.matcher(noun).matches()) {
            return noun + "es";
        }
        if (PLURAL3.matcher(noun).matches()) {
            return Str.sub(noun, 0, -1) + "ies";
        }
        if (PLURAL1U.matcher(noun).matches()) {
            return noun + "ES";
        }
        if (PLURAL2U.matcher(noun).matches()) {
            return noun + "ES";
        }
        if (PLURAL3U.matcher(noun).matches()) {
            return Str.sub(noun, 0, -1) + "IES";
        }
        boolean upper = Character.isUpperCase(noun.charAt(noun.length() - 1));
        return noun + (upper ? "S" : "s");
    }

    public static String singular(String noun) {
        String singular;
        if (U.isEmpty((String)noun)) {
            return noun;
        }
        if (noun.toLowerCase().endsWith("s") && English.plural(singular = Str.sub(noun, 0, -1)).equals(noun)) {
            return singular;
        }
        if (noun.toLowerCase().endsWith("es") && English.plural(singular = Str.sub(noun, 0, -2)).equals(noun)) {
            return singular;
        }
        if (noun.toLowerCase().endsWith("ies") && !(singular = Str.sub(noun, 0, -1)).isEmpty()) {
            boolean upper = Character.isUpperCase(singular.charAt(singular.length() - 1));
            if (English.plural(singular = singular + (upper ? (char)'Y' : 'y')).equals(noun)) {
                return singular;
            }
        }
        return noun;
    }
}

