/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.concurrent.impl;

import java.util.concurrent.TimeoutException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Err;
import org.rapidoid.concurrent.Future;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class FutureImpl<T>
extends RapidoidThing
implements Future<T> {
    private volatile boolean done;
    private volatile T result;
    private volatile Throwable error;

    public void setResult(T result) {
        this.result = result;
        this.done = true;
    }

    public void setError(Throwable error) {
        this.error = error;
        this.done = true;
    }

    @Override
    public T get() {
        try {
            return this.get(Long.MAX_VALUE);
        }
        catch (TimeoutException e) {
            throw Err.notExpected();
        }
    }

    @Override
    public T get(long timeoutMs) throws TimeoutException {
        return this.get(timeoutMs, 5L);
    }

    @Override
    public T get(long timeoutMs, long sleepingIntervalMs) throws TimeoutException {
        long waitingSince = U.time();
        while (!this.isDone()) {
            if (Msc.timedOut(waitingSince, timeoutMs)) {
                throw new TimeoutException();
            }
            U.sleep((long)sleepingIntervalMs);
        }
        if (this.getError() != null) {
            throw U.rte((String)"Cannot get the result, there was an error!", (Throwable)this.error);
        }
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isSuccessful() {
        U.must((boolean)this.done, (String)"The promise is not done yet!");
        return this.error == null;
    }
}

