/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigImpl;
import org.rapidoid.env.Env;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.GlobalCfg;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Conf
extends RapidoidThing {
    private static final String CONFIG_NAME = Msc.isPlatform() ? "rapidoid" : "config";
    public static final Config ROOT = new ConfigImpl(CONFIG_NAME, true);
    private static final Map<String, Config> SECTIONS = Coll.autoExpandingMap(new Mapper<String, Config>(){

        @Override
        public Config map(String name) throws Exception {
            return Conf.createSection(name);
        }
    });
    public static final Config SYSTEM = Conf.section("system");
    public static final Config RAPIDOID = Conf.section("rapidoid");
    public static final Config RAPIDOID_ADMIN = Conf.section("rapidoid-admin");
    public static final Config USERS = Conf.section("users");
    public static final Config JOBS = Conf.section("jobs");
    public static final Config OAUTH = Conf.section("oauth");
    public static final Config JDBC = Conf.section("jdbc");
    public static final Config HIBERNATE = Conf.section("hibernate");
    public static final Config C3P0 = Conf.section("c3p0");
    public static final Config HIKARI = Conf.section("hikari");
    public static final Config APP = Conf.section("app");
    public static final Config GUI = Conf.section("gui");
    public static final Config HTTP = Conf.section("http");
    public static final Config REVERSE_PROXY = Conf.section("reverse-proxy");
    public static final Config NET = Conf.section("net");
    public static final Config TLS = Conf.section("tls");
    public static final Config ON = Conf.section("on");
    public static final Config ADMIN = Conf.section("admin");
    public static final Config TOKEN = Conf.section("token");
    public static final Config PROXY = Conf.section("proxy");
    public static final Config LOG = Conf.section("log");
    public static final Config API = Conf.section("api");
    public static final Config PAGES = Conf.section("pages");
    public static final Config BENCHMARK = Conf.section("benchmark");

    static void applyConfig(Config config) {
        RapidoidEnv.touch();
        if (Env.isInitialized() && !Env.production()) {
            Log.options().fancy(true);
        }
        if (config == ROOT) {
            LogLevel logLevel;
            boolean fancy;
            String appJar;
            String root = Env.root();
            if (Msc.dockerized()) {
                U.must((boolean)U.notEmpty((String)root), (String)"The root must be configured in a Dockerized environment!");
                if (!APP.has("jar")) {
                    APP.set("jar", Msc.path(root, "app.jar"));
                }
            }
            if (U.notEmpty((String)(appJar = APP.entry("jar").str().getOrNull()))) {
                ClasspathUtil.appJar(appJar);
            }
            if (fancy = LOG.entry("fancy").bool().or(Msc.hasConsole()).booleanValue()) {
                Log.options().fancy(true);
            }
            if ((logLevel = LOG.entry("level").to(LogLevel.class).getOrNull()) != null && !Env.test()) {
                Log.setLogLevel((LogLevel)logLevel);
            }
            if (GlobalCfg.quiet()) {
                Log.setLogLevel((LogLevel)LogLevel.ERROR);
            }
        }
    }

    public static synchronized void reset() {
        ROOT.reset();
    }

    public static synchronized Config section(String name) {
        return SECTIONS.get(name);
    }

    public static synchronized Config section(Class<?> clazz) {
        return Conf.section(clazz.getSimpleName());
    }

    private static Config createSection(String name) {
        return ROOT.sub(name);
    }

    public static boolean isInitialized() {
        return ROOT.isInitialized();
    }

    public static void setFilenameBase(String filenameBase) {
        ROOT.setFilenameBase(filenameBase);
    }

    public static void setPath(String path) {
        ROOT.setPath(path);
    }
}

