/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.io.FileSearch;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class IO
extends RapidoidThing {
    public static URL resource(String filename) {
        return IO.classLoader().getResource(filename);
    }

    public static InputStream resourceAsStream(String filename) {
        return IO.classLoader().getResourceAsStream(filename.replace('\\', '/'));
    }

    public static ClassLoader classLoader() {
        ClassLoader classLoader;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = classLoader = thread != null ? thread.getContextClassLoader() : null;
        if (classLoader == null) {
            classLoader = IO.class.getClassLoader();
        }
        return classLoader;
    }

    public static String name(String resourceName) {
        int urlPos = resourceName.indexOf(":/");
        if (urlPos > 0) {
            return resourceName;
        }
        return resourceName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static File file(String filename) {
        URL res;
        File file = new File(filename = IO.name(filename));
        if (!file.exists() && (res = IO.resource(filename)) != null) {
            return new File(res.getFile());
        }
        return file;
    }

    public static byte[] loadBytes(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int readN;
            while ((readN = input.read(buffer)) != -1) {
                output.write(buffer, 0, readN);
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return output.toByteArray();
    }

    public static byte[] readWithTimeout(InputStream input) {
        return IO.readWithTimeoutUntil(input, null);
    }

    public static byte[] readWithTimeoutUntil(InputStream input, Mapper<byte[], Boolean> finish) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int readN;
            while ((readN = input.read(buffer)) != -1) {
                output.write(buffer, 0, readN);
                byte[] bytes = output.toByteArray();
                if (finish == null || !Lmbd.eval(finish, bytes).booleanValue()) continue;
                break;
            }
        }
        catch (SocketTimeoutException readN) {
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return output.toByteArray();
    }

    public static String loadResourceAsString(String filename) {
        byte[] bytes = IO.loadBytes(filename);
        return bytes != null ? new String(bytes) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(String filename) {
        InputStream input = null;
        try {
            File file;
            input = IO.resourceAsStream(filename);
            if (input == null && (file = new File(filename)).exists()) {
                try {
                    input = new FileInputStream(filename);
                }
                catch (FileNotFoundException e) {
                    throw U.rte((Throwable)e);
                }
            }
            byte[] byArray = input != null ? IO.loadBytes(input) : null;
            return byArray;
        }
        finally {
            IO.close(input, true);
        }
    }

    public static byte[] classBytes(String fullClassName) {
        return IO.loadBytes(fullClassName.replace('.', '/') + ".class");
    }

    public static List<String> readLines(BufferedReader reader) {
        List lines = U.list();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return lines;
    }

    public static String load(String filename) {
        byte[] bytes = IO.loadBytes(filename);
        return bytes != null ? new String(bytes) : null;
    }

    public static List<String> loadLines(String filename) {
        byte[] bytes = IO.loadBytes(filename);
        if (bytes == null) {
            return null;
        }
        return IO.readLines(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes))));
    }

    public static List<String> loadLines(String filename, boolean filterEmpty, String commentPrefix) {
        List<String> lines = IO.loadLines(filename);
        List lines2 = U.list();
        for (String line : lines) {
            String s = line.trim();
            if (filterEmpty && s.isEmpty() || commentPrefix != null && s.startsWith(commentPrefix)) continue;
            lines2.add(s);
        }
        return lines2;
    }

    public static Map<String, String> loadMap(String filename) {
        InputStream input = IO.resourceAsStream(filename);
        if (input == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        Map linesMap = U.map();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (U.isEmpty((String)line)) continue;
                String[] parts = line.split("=", 2);
                linesMap.put(parts[0], parts.length > 1 ? parts[1] : "");
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return linesMap;
    }

    public static void save(String filename, String content) {
        IO.save(filename, content.getBytes());
    }

    public static void save(String filename, byte[] content) {
        IO.save(filename, content, 3);
    }

    public static void append(String filename, byte[] content) {
        IO.writeToFile(filename, content, true, 3);
    }

    public static void save(String filename, byte[] content, int retries) {
        IO.writeToFile(filename, content, false, retries);
    }

    private static void writeToFile(String filename, byte[] content, boolean append, int retries) {
        U.notNull((Object)filename, (String)"filename", (Object[])new Object[0]);
        U.notNull((Object)content, (String)"content", (Object[])new Object[0]);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename, append);
            out.write(content);
            IO.close(out, false);
        }
        catch (FileNotFoundException e) {
            if (retries > 0) {
                try {
                    new File(filename).getCanonicalFile().getParentFile().mkdirs();
                }
                catch (IOException e1) {
                    throw U.rte((Throwable)e1);
                }
                U.sleep((long)200L);
                IO.save(filename, content, retries - 1);
            }
            IO.close(out, true);
            throw U.rte((Throwable)e);
        }
        catch (Exception e) {
            IO.close(out, true);
            throw U.rte((Throwable)e);
        }
    }

    public static void close(Closeable closeable, boolean quiet) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                if (quiet) break block3;
                throw U.rte((Throwable)e);
            }
        }
    }

    public static void delete(String filename) {
        new File(filename).delete();
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode, long position, long size) {
        try {
            File file = new File(filename);
            FileChannel fc = new RandomAccessFile(file, "rw").getChannel();
            return fc.map(mode, position, size);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode) {
        File file = new File(filename);
        U.must((boolean)file.exists());
        return IO.mmap(filename, mode, 0L, file.length());
    }

    public static String getDefaultFilename(String filename) {
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos > 0) {
            return Str.insert(filename, lastDotPos, ".default");
        }
        return filename + ".default";
    }

    public static String getRealOrDefaultFilename(String filename) {
        if (IO.resource(filename) != null) {
            return filename;
        }
        String name = IO.getDefaultFilename(filename);
        return IO.resource(name) != null ? name : filename;
    }

    public static void write(OutputStream out, byte[] content) {
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
    }

    public static void write(OutputStream out, String content) {
        IO.write(out, content.getBytes());
    }

    public static FileSearch find(String name) {
        return IO.find().name(name);
    }

    public static FileSearch find() {
        return new FileSearch();
    }
}

