/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.serialize;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rapidoid.cls.AbstractTypeSpecificVisitor;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.serialize.Ser;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.TUUID;

public class TypeSpecificSerializer
extends AbstractTypeSpecificVisitor<ByteBuffer, Void> {
    public void serialize(ByteBuffer buf, Object value) {
        this.dispatch(buf, value);
    }

    @Override
    public Void dispatch(ByteBuffer buf, Object value) {
        TypeKind kind = Cls.kindOf(value);
        buf.put(Msc.sbyte(Ser.code(kind)));
        return (Void)this.dispatch(buf, kind, value);
    }

    @Override
    public Void processNull(ByteBuffer buf) {
        return null;
    }

    @Override
    public Void processNone(ByteBuffer context) {
        return null;
    }

    @Override
    public Void processDeleted(ByteBuffer context) {
        return null;
    }

    @Override
    public Void processUnknown(ByteBuffer buf, Object value) {
        throw U.rte((String)("Cannot serialize a value of type: " + Cls.of(value).getName()));
    }

    @Override
    public Void process(ByteBuffer buf, boolean value) {
        buf.put(Ser.bool2byte(value));
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, byte value) {
        buf.put(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, short value) {
        buf.putShort(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, char value) {
        buf.putChar(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, int value) {
        buf.putInt(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, long value) {
        buf.putLong(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, float value) {
        buf.putFloat(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, double value) {
        buf.putDouble(value);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, String value) {
        Ser.writeBytes(buf, value.getBytes());
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, Date value) {
        this.process(buf, value.getTime());
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, UUID value) {
        this.process(buf, value.getMostSignificantBits());
        this.process(buf, value.getLeastSignificantBits());
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, TUUID value) {
        this.process(buf, value.time());
        this.process(buf, value.uuidHigh());
        this.process(buf, value.uuidLow());
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, List<?> list) {
        Ser.writeNum(buf, list.size());
        for (Object x : list) {
            this.dispatch(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, Set<?> set) {
        Ser.writeNum(buf, set.size());
        for (Object x : set) {
            this.dispatch(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, Map<?, ?> map) {
        Ser.writeNum(buf, map.size());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            this.dispatch(buf, e.getKey());
            this.dispatch(buf, e.getValue());
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, boolean[] arr) {
        Ser.writeNum(buf, arr.length);
        for (boolean x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, byte[] arr) {
        Ser.writeBytes(buf, arr);
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, short[] arr) {
        Ser.writeNum(buf, arr.length);
        for (short x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, char[] arr) {
        Ser.writeNum(buf, arr.length);
        for (char x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, int[] arr) {
        Ser.writeNum(buf, arr.length);
        for (int x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, long[] arr) {
        Ser.writeNum(buf, arr.length);
        for (long x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, float[] arr) {
        Ser.writeNum(buf, arr.length);
        for (float x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void process(ByteBuffer buf, double[] arr) {
        Ser.writeNum(buf, arr.length);
        for (double x : arr) {
            this.process(buf, x);
        }
        return null;
    }

    @Override
    public Void processArray(ByteBuffer buf, Object[] arr) {
        Ser.writeNum(buf, arr.length);
        for (Object x : arr) {
            this.dispatch(buf, x);
        }
        return null;
    }
}

