/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.serialize.Serialize;
import org.rapidoid.u.U;
import org.rapidoid.util.TokenAuthData;

public class Tokens
extends RapidoidThing {
    public static final String _USER = "_user";
    public static final String _SCOPE = "_scope";
    public static final String _EXPIRES = "_expires";

    public static String serialize(Map<String, ? extends Serializable> token) {
        if (U.notEmpty(token)) {
            byte[] tokenBytes = Tokens.serializeToken(token);
            byte[] tokenEncrypted = Crypto.encrypt(tokenBytes);
            return Str.toWebSafeBase64(tokenEncrypted);
        }
        return "";
    }

    private static byte[] serializeToken(Map<String, ? extends Serializable> token) {
        byte[] dest = new byte[2500];
        try {
            int size = Serialize.serialize(dest, token);
            dest = Arrays.copyOf(dest, size);
        }
        catch (BufferOverflowException e) {
            throw U.rte((String)"The token is too big!");
        }
        return dest;
    }

    public static Map<String, Serializable> deserialize(String token) {
        if (!U.isEmpty((String)token)) {
            byte[] decoded = Str.fromWebSafeBase64(token);
            byte[] tokenDecrypted = Crypto.decrypt(decoded);
            return tokenDecrypted != null ? (Map)Serialize.deserialize(tokenDecrypted) : null;
        }
        return null;
    }

    public static TokenAuthData getAuth(Map<String, ? extends Serializable> token) {
        TokenAuthData data = new TokenAuthData();
        data.user = (String)((Object)token.get(_USER));
        data.scope = Tokens.scope((String)((Object)token.get(_SCOPE)));
        data.expires = (Long)token.get(_EXPIRES);
        if (data.expires == null || data.expires > U.time()) {
            return data;
        }
        return null;
    }

    private static Set<String> scope(String scope) {
        if (U.isEmpty((String)scope)) {
            return null;
        }
        Set scopes = U.set();
        for (String sc : scope.split("\\,")) {
            String[] parts = sc.trim().split("\\:");
            String uri = parts[parts.length - 1];
            if (parts.length == 1) {
                scopes.add(uri);
                continue;
            }
            for (int i = 0; i < parts.length - 1; ++i) {
                scopes.add(parts[i] + " " + uri);
            }
        }
        return scopes;
    }
}

