/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import org.rapidoid.RapidoidThing;
import org.rapidoid.cache.impl.ConcurrentCacheAtom;
import org.rapidoid.commons.Rnd;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class L1CacheSegment<K, V>
extends RapidoidThing {
    private final int bitMask;
    private final int xor = Rnd.rnd();
    private final Object[] keys;
    private final ConcurrentCacheAtom<K, V>[] atoms;
    int indexCounter;
    private volatile ConcurrentCacheAtom<K, V> latest;

    public L1CacheSegment(int size) {
        this.bitMask = Msc.bitMask(Msc.log2(size));
        this.keys = new Object[size];
        this.atoms = new ConcurrentCacheAtom[size];
        this.latest = null;
    }

    public ConcurrentCacheAtom<K, V> find(K key) {
        ConcurrentCacheAtom<K, V> latestAtom = this.latest;
        if (latestAtom != null && U.eq(latestAtom.key, key)) {
            return latestAtom;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            ConcurrentCacheAtom<K, V> atom;
            if (!U.eq((Object)this.keys[i], key) || (atom = this.atoms[i]) == null || !U.eq(atom.key, key)) continue;
            return atom;
        }
        return null;
    }

    public void add(int hash, ConcurrentCacheAtom<K, V> atom) {
        int index;
        ConcurrentCacheAtom<K, V> oldAtom;
        if ((oldAtom = this.atoms[index = (hash ^ this.xor ^ this.indexCounter++) & this.bitMask]) == null || atom.approxAccessCounter > oldAtom.approxAccessCounter) {
            this.keys[index] = atom.key;
            this.atoms[index] = atom;
            this.latest = atom;
        }
    }

    public void invalidate(K key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!U.eq((Object)this.keys[i], key)) continue;
            ConcurrentCacheAtom<K, V> atom = this.atoms[i];
            if (!U.eq(atom.key, key)) continue;
            atom.invalidate();
            this.latest = atom;
        }
    }

    public void set(K key, V value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!U.eq((Object)this.keys[i], key)) continue;
            ConcurrentCacheAtom<K, V> atom = this.atoms[i];
            if (!U.eq(atom.key, key)) continue;
            atom.set(value);
            this.latest = atom;
        }
    }

    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.atoms[i] = null;
        }
        this.latest = null;
    }
}

