/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cls;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.collection.AutoExpandingMap;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Arr;
import org.rapidoid.commons.Dates;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.io.IO;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.TUUID;
import org.rapidoid.var.Var;
import org.rapidoid.var.Vars;

public class Cls
extends RapidoidThing {
    private static Pattern JRE_CLASS_PATTERN = Pattern.compile("^(java|javax|javafx|com\\.sun|sun|com\\.oracle|oracle|jdk|org\\.omg|org\\.w3c).*");
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = U.map((Object[])new Object[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class});
    private static Set<String> RAPIDOID_CLASSES = U.set(IO.loadLines("rapidoid-classes.txt"));
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private Cls() {
    }

    public static TypeKind kindOf(Class<?> type) {
        return TypeKind.ofType(type);
    }

    public static TypeKind kindOf(Object value) {
        return TypeKind.of(value);
    }

    public static void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            Class<?> c = instance.getClass();
            while (c.getSuperclass() != null) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(instance, value);
                    return;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    c = c.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot set field value!", (Throwable)e);
        }
        throw U.rte((String)"Cannot find the field '%s' in the class '%s'", (Object[])new Object[]{fieldName, instance.getClass()});
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot set field value!", (Throwable)e);
        }
    }

    public static <T> T getFieldValue(Object instance, String fieldName, T defaultValue) {
        try {
            return (T)Cls.getFieldValue(instance, fieldName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object getFieldValue(Object instance, String fieldName) {
        try {
            Class<?> c = instance.getClass();
            while (c.getSuperclass() != null) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    return Cls.getFieldValue(field, instance);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    c = c.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get field value!", (Throwable)e);
        }
        throw U.rte((String)"Cannot find the field '%s' in the class '%s'", (Object[])new Object[]{fieldName, instance.getClass()});
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            Object value = field.get(instance);
            return value;
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get field value!", (Throwable)e);
        }
    }

    public static List<Annotation> getAnnotations(Class<?> clazz) {
        List allAnnotations = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                Annotation[] annotations;
                for (Annotation an : annotations = c.getDeclaredAnnotations()) {
                    allAnnotations.add(an);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get annotations!", (Throwable)e);
        }
        return allAnnotations;
    }

    public static List<Field> getFields(Class<?> clazz) {
        List allFields = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    allFields.add(field);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get fields!", (Throwable)e);
        }
        return allFields;
    }

    public static List<Field> getFieldsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List annotatedFields = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    annotatedFields.add(field);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get annotated fields!", (Throwable)e);
        }
        return annotatedFields;
    }

    public static List<Method> getMethods(Class<?> clazz) {
        List methods = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                for (Method method : c.getDeclaredMethods()) {
                    methods.add(method);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get methods!", (Throwable)e);
        }
        return methods;
    }

    public static List<Method> getMethodsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List annotatedMethods = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                Method[] methods;
                for (Method method : methods = c.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    annotatedMethods.add(method);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return annotatedMethods;
    }

    public static List<Method> getMethodsNamed(Class<?> clazz, String name) {
        List methods = U.list();
        try {
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                for (Method method : c.getDeclaredMethods()) {
                    if (!method.getName().equals(name)) continue;
                    methods.add(method);
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return methods;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e1) {
                throw U.rte((String)"Cannot find method: %s", (Throwable)e, (Object[])new Object[]{name});
            }
        }
        catch (SecurityException e) {
            throw U.rte((String)"Cannot access method: %s", (Throwable)e, (Object[])new Object[]{name});
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw U.rte((String)"Cannot find field: %s", (Throwable)e, (Object[])new Object[]{name});
        }
        catch (SecurityException e) {
            throw U.rte((String)"Cannot access field: %s", (Throwable)e, (Object[])new Object[]{name});
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static <T> T invokeStatic(Method m, Object ... args) {
        try {
            m.setAccessible(true);
            return (T)m.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), U.str((Object[])args)});
        }
        catch (IllegalArgumentException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), U.str((Object[])args)});
        }
        catch (InvocationTargetException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), U.str((Object[])args)});
        }
    }

    public static <T> T invoke(Method m, Object target, Object ... args) {
        try {
            m.setAccessible(true);
            return (T)m.invoke(target, args);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), U.str((Object[])args)});
        }
    }

    public static <T> T invoke(Constructor<?> constructor, Object ... args) {
        try {
            constructor.setAccessible(true);
            return (T)constructor.newInstance(args);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot invoke constructor '%s' with args: %s", (Throwable)e, (Object[])new Object[]{constructor.getName(), U.str((Object[])args)});
        }
    }

    public static <T> T invokeRethrowing(Method method, Object target, Object ... args) throws Throwable {
        try {
            return (T)method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw cause != null ? cause : e;
        }
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        try {
            LinkedList interfaces = new LinkedList();
            Class<?> c = clazz;
            while (c.getSuperclass() != null) {
                for (Class<?> interf : c.getInterfaces()) {
                    interfaces.add(interf);
                }
                c = c.getSuperclass();
            }
            return interfaces.toArray(new Class[interfaces.size()]);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot retrieve implemented interfaces!", (Throwable)e);
        }
    }

    public static boolean annotatedMethod(Object instance, String methodName, Class<Annotation> annotation) {
        try {
            Method method = instance.getClass().getMethod(methodName, new Class[0]);
            return method.getAnnotation(annotation) != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot find the constructor for %s with param types: %s", (Throwable)e, (Object[])new Object[]{clazz, U.str((Object[])paramTypes)});
        }
    }

    public static <T> T newInstance(Class<T> clazz, Map<String, Object> properties) {
        if (U.isEmpty(properties)) {
            return Cls.newInstance(clazz);
        }
        Collection<Object> values = properties.values();
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            Object[] args = Cls.getAssignableArgs(paramTypes, values);
            if (args == null) continue;
            try {
                return (T)constr.newInstance(args);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        throw U.rte((String)"Cannot find appropriate constructor for %s with args %s!", (Object[])new Object[]{clazz, values});
    }

    public static Object[] getAssignableArgs(Class<?>[] types, Collection<?> properties) {
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            args[i] = Cls.getUniqueInstanceOf(type, properties);
        }
        return args;
    }

    public static <T> T getUniqueInstanceOf(Class<T> type, Collection<?> values) {
        T instance = null;
        for (Object obj : values) {
            if (!Cls.instanceOf(obj, type)) continue;
            if (instance == null) {
                instance = (T)obj;
                continue;
            }
            throw U.rte((String)"Found more than one instance of %s: %s and %s", (Object[])new Object[]{type, instance, obj});
        }
        return instance;
    }

    public static Object[] instantiateAll(Class<?> ... classes) {
        Object[] instances = new Object[classes.length];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = Cls.newInstance(classes[i]);
        }
        return instances;
    }

    public static Object[] instantiateAll(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Object[] instances = new Object[classes.size()];
        int i = 0;
        for (Class<?> clazz : classes) {
            instances[i++] = Cls.newInstance(clazz);
        }
        return instances;
    }

    public static ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static <T> T convert(String value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (Enum.class.isAssignableFrom(toType)) {
            T[] ens;
            for (T t : ens = toType.getEnumConstants()) {
                Enum en = (Enum)t;
                if (!en.name().equalsIgnoreCase(value)) continue;
                return (T)en;
            }
            throw U.rte((String)"Cannot find the enum constant: %s.%s", (Object[])new Object[]{toType, value});
        }
        TypeKind targetKind = Cls.kindOf(toType);
        switch (targetKind) {
            case NULL: {
                throw Err.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if ("y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                    return (T)Boolean.TRUE;
                }
                if ("n".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return (T)Boolean.FALSE;
                }
                throw U.rte((String)"Cannot convert the string value '%s' to boolean!", (Object[])new Object[]{value});
            }
            case BYTE: 
            case BYTE_OBJ: {
                return (T)new Byte(value);
            }
            case SHORT: 
            case SHORT_OBJ: {
                return (T)new Short(value);
            }
            case CHAR: 
            case CHAR_OBJ: {
                return (T)new Character(value.charAt(0));
            }
            case INT: 
            case INT_OBJ: {
                return (T)new Integer(value);
            }
            case LONG: 
            case LONG_OBJ: {
                return (T)new Long(value);
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                return (T)new Float(value);
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                return (T)new Double(value);
            }
            case STRING: {
                return (T)value;
            }
            case UNKNOWN: {
                Constructor<T> constructor;
                try {
                    constructor = toType.getConstructor(String.class);
                }
                catch (Exception e) {
                    throw U.rte((String)"Cannot convert string value to type '%s'!", (Object[])new Object[]{toType});
                }
                try {
                    return constructor.newInstance(value);
                }
                catch (Exception e) {
                    throw U.rte((String)"Cannot invoke constructor, trying to convert string value to type '%s'!", (Object[])new Object[]{toType});
                }
            }
            case DATE: {
                return (T)Dates.date(value);
            }
            case UUID: {
                return (T)UUID.fromString(value);
            }
            case TUUID: {
                return (T)TUUID.fromString(value);
            }
        }
        throw U.rte((String)"Cannot convert String to type '%s'!", (Object[])new Object[]{toType});
    }

    public static <T> T convert(Object value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (value instanceof String) {
            return Cls.convert((String)value, toType);
        }
        TypeKind targetKind = Cls.kindOf(toType);
        boolean isNum = value instanceof Number;
        switch (targetKind) {
            case NULL: {
                throw Err.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if (value instanceof Boolean) {
                    return (T)value;
                }
                if (value instanceof Number) {
                    Number num = (Number)value;
                    Boolean asBool = num.longValue() != 0L;
                    return (T)asBool;
                }
                throw U.rte((String)"Cannot convert the value '%s' to boolean!", (Object[])new Object[]{value});
            }
            case BYTE: 
            case BYTE_OBJ: {
                if (isNum) {
                    return (T)new Byte(((Number)value).byteValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to byte!", (Object[])new Object[]{value});
            }
            case SHORT: 
            case SHORT_OBJ: {
                if (isNum) {
                    return (T)new Short(((Number)value).shortValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to short!", (Object[])new Object[]{value});
            }
            case CHAR: 
            case CHAR_OBJ: {
                if (isNum) {
                    return (T)new Character((char)((Number)value).intValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to char!", (Object[])new Object[]{value});
            }
            case INT: 
            case INT_OBJ: {
                if (isNum) {
                    return (T)new Integer(((Number)value).intValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to int!", (Object[])new Object[]{value});
            }
            case LONG: 
            case LONG_OBJ: {
                if (isNum) {
                    return (T)new Long(((Number)value).longValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to long!", (Object[])new Object[]{value});
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                if (isNum) {
                    return (T)new Float(((Number)value).floatValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to float!", (Object[])new Object[]{value});
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                if (isNum) {
                    return (T)new Double(((Number)value).doubleValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to double!", (Object[])new Object[]{value});
            }
            case STRING: {
                if (value instanceof Date) {
                    return (T)Dates.str((Date)value);
                }
                if (value instanceof byte[]) {
                    return (T)new String((byte[])value);
                }
                if (value instanceof char[]) {
                    return (T)new String((char[])value);
                }
                return (T)U.str((Object)value);
            }
            case UNKNOWN: {
                throw U.rte((String)"Cannot convert the value to type '%s'!", (Object[])new Object[]{toType});
            }
            case DATE: {
                if (value instanceof Date) {
                    return (T)value;
                }
                if (value instanceof Number) {
                    return (T)new Date(((Number)value).longValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to date!", (Object[])new Object[]{value});
            }
            case UUID: {
                if (value instanceof byte[]) {
                    return (T)Msc.bytesToUUID((byte[])value);
                }
                throw U.rte((String)"Cannot convert the value '%s' to UUID!", (Object[])new Object[]{value});
            }
            case TUUID: {
                if (value instanceof byte[]) {
                    return (T)TUUID.fromBytes((byte[])value);
                }
                throw U.rte((String)"Cannot convert the value '%s' to TUUID!", (Object[])new Object[]{value});
            }
        }
        throw Err.notExpected();
    }

    public static Map<String, Class<?>> classMap(Iterable<Class<?>> classes) {
        LinkedHashMap map = new LinkedHashMap();
        for (Class<?> cls : classes) {
            map.put(cls.getSimpleName(), cls);
        }
        return map;
    }

    public static Class<?>[] typesOf(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i] != null ? args[i].getClass() : null;
        }
        return types;
    }

    public static Method findMethodByArgs(Class<? extends Object> clazz, String name, Object ... args) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!method.getName().equals(name) || !Cls.areAssignable(paramTypes, args)) continue;
            return method;
        }
        return null;
    }

    public static <T> Class<T> clazz(Type type) {
        return (Class)(type instanceof Class ? type : Object.class);
    }

    public static <T> Class<T> of(T obj) {
        return obj != null ? obj.getClass() : Object.class;
    }

    public static String str(Object value) {
        return Cls.convert(value, String.class);
    }

    public static boolean bool(Object value) {
        return (Boolean)U.or((Object)Cls.convert(value, Boolean.class), (Object)false);
    }

    public static ParameterizedType generic(Type type) {
        return type instanceof ParameterizedType ? (ParameterizedType)type : null;
    }

    public static boolean isJREClass(String className) {
        return JRE_CLASS_PATTERN.matcher(className).matches();
    }

    public static boolean isRapidoidClass(String className) {
        className = className.split("\\$")[0];
        return RAPIDOID_CLASSES.contains(className);
    }

    public static boolean isIdeOrToolClass(String className) {
        return className.startsWith("com.intellij.rt.execution.");
    }

    public static Set<String> getRapidoidClasses() {
        return RAPIDOID_CLASSES;
    }

    public static boolean isRapidoidClass(Class<?> clazz) {
        return Cls.isRapidoidClass(clazz.getName());
    }

    public static boolean isJREType(Class<?> type) {
        return Cls.isJREClass(type.getName());
    }

    public static <T> Class<T> getWrapperClass(Class<T> c) {
        U.must((boolean)c.isPrimitive());
        return c.isPrimitive() ? PRIMITIVE_WRAPPERS.get(c) : c;
    }

    public static boolean instanceOf(Object obj, Class<?> ... classes) {
        return obj != null ? Cls.isAssignableTo(obj.getClass(), classes) : false;
    }

    public static boolean isAssignableTo(Class<?> clazz, Class<?> ... targetClasses) {
        for (Class<?> cls : targetClasses) {
            if (cls.isPrimitive()) {
                if (cls.isAssignableFrom(clazz)) {
                    return true;
                }
                cls = Cls.getWrapperClass(cls);
            }
            if (!cls.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean areAssignable(Class<?>[] types, Object[] values) {
        if (types.length != values.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            Object val = values[i];
            if (val == null || Cls.instanceOf(val, types[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T newInstance(Class<T> clazz) {
        Err.argMust(clazz != AutoExpandingMap.class, "Cannot instantiate AutoExpandingMap!", new Object[0]);
        if (clazz == List.class) {
            return (T)U.list();
        }
        if (clazz == Set.class) {
            return (T)U.set();
        }
        if (clazz == Map.class) {
            return (T)U.map();
        }
        if (clazz == ConcurrentMap.class) {
            return (T)Coll.concurrentMap();
        }
        if (clazz.getName().equals("java.util.Collections$SynchronizedSet")) {
            return (T)Coll.synchronizedSet(new Object[0]);
        }
        if (clazz.getName().equals("java.util.Collections$SynchronizedList")) {
            return (T)Coll.synchronizedList(new Object[0]);
        }
        if (clazz.getName().equals("java.util.Collections$SynchronizedMap")) {
            return (T)Coll.synchronizedMap();
        }
        if (clazz == Var.class) {
            return (T)Vars.var("<new>", null);
        }
        if (clazz == Object.class) {
            return (T)new Object();
        }
        return Cls.newBeanInstance(clazz);
    }

    public static <T> T newBeanInstance(Class<T> clazz) {
        try {
            Constructor<T> constr = clazz.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw U.rte((String)("Couldn't instantiate " + clazz), (Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            if (!Cls.areAssignable(paramTypes, args)) continue;
            try {
                constr.setAccessible(true);
                return (T)constr.newInstance(args);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        throw U.rte((String)"Cannot find appropriate constructor for %s with args %s!", (Object[])new Object[]{clazz, U.str((Object[])args)});
    }

    public static <T> T customizable(Class<T> clazz, Object ... args) {
        String customClassName = "Customized" + clazz.getSimpleName();
        Class<T> customClass = Cls.getClassIfExists(customClassName);
        if (customClass == null) {
            customClass = Cls.getClassIfExists("custom." + customClassName);
        }
        if (customClass != null && !clazz.isAssignableFrom(customClass)) {
            customClass = null;
        }
        return Cls.newInstance((Class)U.or(customClass, clazz), args);
    }

    public static <T> Class<T> getClassIfExists(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Class<T> get(String className) {
        if (className.equals("byte")) {
            return (Class)U.cast(Byte.TYPE);
        }
        if (className.equals("short")) {
            return (Class)U.cast(Short.TYPE);
        }
        if (className.equals("int")) {
            return (Class)U.cast(Integer.TYPE);
        }
        if (className.equals("long")) {
            return (Class)U.cast(Long.TYPE);
        }
        if (className.equals("float")) {
            return (Class)U.cast(Float.TYPE);
        }
        if (className.equals("double")) {
            return (Class)U.cast(Double.TYPE);
        }
        if (className.equals("boolean")) {
            return (Class)U.cast(Boolean.TYPE);
        }
        if (className.endsWith("[]")) {
            String cls = Str.trimr(className, "[]");
            return (Class)U.cast(Array.newInstance(Cls.get(cls), 0).getClass());
        }
        try {
            return (Class)U.cast(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw U.rte((Throwable)e);
        }
    }

    public static Class<?> unproxy(Class<?> cls) {
        if (Proxy.class.isAssignableFrom(cls)) {
            for (Class<?> interf : cls.getInterfaces()) {
                if (Cls.isJREClass(interf.getCanonicalName())) continue;
                return interf;
            }
            throw U.rte((String)"Cannot unproxy the class: %s!", (Object[])new Object[]{cls});
        }
        return cls;
    }

    public static String entityName(Class<?> cls) {
        return Cls.unproxy(cls).getSimpleName();
    }

    public static String entityName(Object entity) {
        U.notNull((Object)entity, (String)"entity", (Object[])new Object[0]);
        return Cls.entityName(entity.getClass());
    }

    public static boolean isSimple(Object target) {
        return Cls.kindOf(target).isConcrete();
    }

    public static boolean isNumber(Object target) {
        return Cls.kindOf(target).isNumber();
    }

    public static boolean isDataStructure(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz);
    }

    public static boolean isBeanType(Class<?> clazz) {
        return !(clazz == null || clazz == Object.class || Cls.kindOf(clazz) != TypeKind.UNKNOWN || clazz.getName().startsWith("java.") && !clazz.getName().startsWith("java.lang.management.") || clazz.getName().startsWith("javax.") && !clazz.getName().startsWith("javax.management.") || clazz.isAnnotation() || clazz.isEnum() || clazz.isInterface() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz));
    }

    public static boolean isAppBeanType(Class<?> clazz) {
        return Cls.isBeanType(clazz) && !Cls.isJREType(clazz);
    }

    public static boolean isBean(Object target) {
        return target != null && Cls.isBeanType(target.getClass());
    }

    public static boolean isAppBean(Object target) {
        return target != null && Cls.isAppBeanType(target.getClass());
    }

    public static <T, T2> T struct(Class<T> clazz1, Class<T2> clazz2, Object obj) {
        List items = U.list();
        if (obj instanceof Map) {
            Map map = (Map)U.cast((Object)obj);
            for (Map.Entry e : map.entrySet()) {
                items.add(Cls.createFromEntry(clazz2, e, null));
            }
        } else if (obj instanceof List) {
            List list = (List)U.cast((Object)obj);
            for (Object o : list) {
                if (o instanceof Map) {
                    Map map = (Map)U.cast(o);
                    if (map.isEmpty()) continue;
                    if (map.size() == 1) {
                        items.add(Cls.createFromEntry(clazz2, map.entrySet().iterator().next(), null));
                        continue;
                    }
                    Map extra = U.map();
                    Iterator it = (Iterator)U.cast(map.entrySet().iterator());
                    Map.Entry firstEntry = (Map.Entry)it.next();
                    while (it.hasNext()) {
                        Map.Entry e = (Map.Entry)U.cast(it.next());
                        extra.put(Cls.str(e.getKey()), e.getValue());
                    }
                    items.add(Cls.createFromEntry(clazz2, firstEntry, extra));
                    continue;
                }
                items.add(Cls.newInstance(clazz2, Cls.str(o), null, null));
            }
        } else {
            items.add(Cls.newInstance(clazz2, Cls.str(obj), null, null));
        }
        return Cls.newInstance(clazz1, items);
    }

    private static <T2> T2 createFromEntry(Class<T2> clazz2, Map.Entry<?, ?> e, Map<String, Object> extra) {
        String key = Cls.str(e.getKey());
        T2 item = Cls.newInstance(clazz2, key, e.getValue(), extra);
        return item;
    }

    public static boolean exists(String className) {
        try {
            Class.forName(className, false, Cls.classLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Method getLambdaMethod(Serializable lambda) {
        return Cls.getLambdaMethod(lambda, "execute");
    }

    public static Method getLambdaMethod(Serializable lambda, String functionalMethodName) {
        Method writeReplace = Cls.findMethod(lambda.getClass(), "writeReplace", new Class[0]);
        if (writeReplace == null) {
            List<Method> methods = Cls.getMethodsNamed(lambda.getClass(), functionalMethodName);
            U.must((boolean)U.notEmpty(methods), (String)"Cannot find the lambda method named: %s", (Object)functionalMethodName);
            for (Method method : methods) {
                Class<?>[] paramTypes;
                for (Class<?> paramType : paramTypes = method.getParameterTypes()) {
                    if (paramType.getName().equals("java.lang.Object")) continue;
                    return method;
                }
            }
            U.must((methods.size() == 1 ? 1 : 0) != 0, (String)"Expected one, but found %s lambda methods named: %s", (Object)methods.size(), (Object)functionalMethodName);
            return methods.get(0);
        }
        Object serializedLambda = Cls.invoke(writeReplace, (Object)lambda, new Object[0]);
        Method getImplClass = Cls.findMethod(serializedLambda.getClass(), "getImplClass", new Class[0]);
        if (getImplClass != null) {
            Class<?> cls;
            String implClass = (String)Cls.invoke(getImplClass, serializedLambda, new Object[0]);
            String className = implClass.replaceAll("/", ".");
            try {
                cls = Class.forName(className, true, lambda.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw U.rte((String)"Cannot find or load the lambda class: %s", (Object[])new Object[]{className});
            }
            Method getImplMethodName = Cls.findMethod(serializedLambda.getClass(), "getImplMethodName", new Class[0]);
            String lambdaMethodName = (String)Cls.invoke(getImplMethodName, serializedLambda, new Object[0]);
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(lambdaMethodName)) continue;
                return method;
            }
            throw U.rte((String)"Cannot find the lambda method: %s#%s", (Object[])new Object[]{cls.getName(), lambdaMethodName});
        }
        throw U.rte((String)"Cannot find the 'getImplClass' method of the serialized lambda!");
    }

    public static List<Method> getDeclaredMethods(Class<?> clazz) {
        CtClass cc;
        ClassPool cp = new ClassPool();
        cp.insertClassPath((ClassPath)new ClassClassPath(clazz));
        try {
            cc = cp.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw U.rte((String)"Cannot find the target class!", (Throwable)e);
        }
        List methods = U.list();
        for (CtMethod m : cc.getDeclaredMethods()) {
            try {
                methods.add(Cls.getMethod(clazz, m.getName(), Cls.ctTypes(m.getParameterTypes())));
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        return methods;
    }

    private static Class<?>[] ctTypes(CtClass[] types) {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = Cls.get(types[i].getName());
        }
        return classes;
    }

    public static String[] getMethodParameterNames(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] names = new String[paramTypes.length];
        boolean defaultNames = true;
        Method getParameters = Cls.findMethod(method.getClass(), "getParameters", new Class[0]);
        if (getParameters != null) {
            Object[] parameters = (Object[])Cls.invoke(getParameters, (Object)method, new Object[0]);
            for (int i = 0; i < parameters.length; ++i) {
                names[i] = (String)Beany.getPropValue(parameters[i], "name");
                U.notNull((Object)names[i], (String)"parameter name", (Object[])new Object[0]);
                if (names[i].equals("arg" + i)) continue;
                defaultNames = false;
            }
        }
        if (defaultNames) {
            CtMethod cm;
            boolean useIndexMapping;
            try {
                ClassPool cp = new ClassPool();
                cp.insertClassPath((ClassPath)new ClassClassPath(method.getDeclaringClass()));
                CtClass cc = cp.get(method.getDeclaringClass().getName());
                useIndexMapping = cc.getClassFile().getMajorVersion() >= 52;
                CtClass[] params = new CtClass[paramTypes.length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = cp.get(method.getParameterTypes()[i].getName());
                }
                cm = cc.getDeclaredMethod(method.getName(), params);
            }
            catch (NotFoundException e) {
                throw U.rte((String)"Cannot find the target method!", (Throwable)e);
            }
            MethodInfo methodInfo = cm.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute != null) {
                String var;
                int index;
                int i;
                LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
                int offset = Modifier.isStatic((int)cm.getModifiers()) ? 0 : 1;
                for (i = 0; i < names.length; ++i) {
                    names[i] = null;
                }
                for (i = 0; i < attr.tableLength(); ++i) {
                    index = i - offset;
                    if (useIndexMapping) {
                        index = attr.index(index);
                    }
                    var = attr.variableName(i);
                    if (index < 0 || index >= names.length || "this".equals(var)) continue;
                    names[index] = var;
                }
                if (!Cls.validNames(names)) {
                    for (i = 0; i < names.length; ++i) {
                        names[i] = null;
                    }
                    for (i = 0; i < attr.tableLength(); ++i) {
                        index = i - offset;
                        var = attr.variableName(i);
                        if (index < 0 || index >= names.length || "this".equals(var)) continue;
                        names[index] = var;
                    }
                }
            }
            U.must((boolean)Cls.validNames(names), (String)"Couldn't retrieve the parameter names! Please report this problem. You can explicitly specify the names using @Param(\"thename\"), or configure the option '-parameters' on the Java 8 compiler.");
        }
        return names;
    }

    private static boolean validNames(String[] names) {
        for (String name : names) {
            if (name != null) continue;
            return false;
        }
        return true;
    }

    public static String[] getLambdaParameterNames(Serializable lambda) {
        Method lambdaMethod = Cls.getLambdaMethod(lambda);
        Class<?>[] lambdaTypes = lambdaMethod.getParameterTypes();
        String[] names = Cls.getMethodParameterNames(lambdaMethod);
        List methods = U.list();
        for (Class<?> interf : lambda.getClass().getInterfaces()) {
            for (Method m : interf.getMethods()) {
                Class<?>[] types = m.getParameterTypes();
                if (types.length > names.length) continue;
                int diff = names.length - types.length;
                boolean matching = true;
                for (int i = 0; i < types.length; ++i) {
                    if (types[i].isAssignableFrom(lambdaTypes[i + diff])) continue;
                    matching = false;
                }
                if (!matching) continue;
                methods.add(m);
            }
        }
        U.must((methods.size() > 0 ? 1 : 0) != 0, (String)"Cannot find the lambda target method of the functional interface!");
        U.must((methods.size() == 1 ? 1 : 0) != 0, (String)("Found more than one lambda target method of the functional interface: " + methods));
        return Arr.sub(names, names.length - ((Method)methods.get(0)).getParameterTypes().length, names.length);
    }

    public static Class<?> toClass(Object classOrInstance) {
        return classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
    }

    public static boolean isAnnotated(Class<?> type, Class<? extends Annotation> annotation) {
        return type.getAnnotation(annotation) != null;
    }

    public static Object invokeStatic(String className, String methodName, Object ... args) {
        Class cls = Cls.get(className);
        Method method = Cls.findMethodByArgs(cls, methodName, args);
        return Cls.invokeStatic(method, args);
    }
}

