/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.group;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.BeanProperties;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.commons.Str;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Callbacks;
import org.rapidoid.concurrent.Promise;
import org.rapidoid.concurrent.Promises;
import org.rapidoid.group.Action;
import org.rapidoid.group.ActionCondition;
import org.rapidoid.group.GroupOf;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.Manageables;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public abstract class AbstractManageable
extends RapidoidThing
implements Manageable {
    @Override
    public Object runManageableAction(String action) {
        Method method = Cls.findMethod(this.source().getClass(), Str.uncapitalized(action), new Class[0]);
        if (method != null) {
            return Cls.invoke(method, this.source(), new Object[0]);
        }
        return this.doManageableAction(action);
    }

    @Override
    public List<String> getManageableActions() {
        Object source = this.source();
        List actions = U.list();
        List<Method> actionMethods = Cls.getMethodsAnnotated(source.getClass(), Action.class);
        Msc.sortByOrder(actionMethods);
        for (Method method : actionMethods) {
            Action action = method.getAnnotation(Action.class);
            actions.add(!action.name().isEmpty() ? action.name() : method.getName());
        }
        for (Method method : Cls.getMethodsAnnotated(source.getClass(), ActionCondition.class)) {
            String name;
            ActionCondition condition = method.getAnnotation(ActionCondition.class);
            U.must((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)("The method return type must be boolean: " + method));
            boolean cond = (Boolean)Cls.invoke(method, source, new Object[0]);
            if (cond) continue;
            if (!condition.name().isEmpty()) {
                name = condition.name();
            } else {
                name = method.getName();
                U.must((boolean)name.startsWith("can"), (String)"The action condition method must start with 'can', to infer the action name!");
                name = Str.uncapitalized(Str.triml(name, "can"));
            }
            actions.remove(name);
        }
        return actions;
    }

    @Override
    public List<String> getManageableProperties() {
        BeanProperties props = Beany.propertiesOf(this.source());
        List ps = U.list();
        for (Prop prop : props) {
            TypeKind kind;
            if (prop.getName().contains("manageable") || !(kind = Cls.kindOf(prop.getType())).isPrimitive() && !kind.isNumber() && !kind.isArray() && kind != TypeKind.STRING && kind != TypeKind.DATE) continue;
            ps.add(prop.getName());
        }
        return ps;
    }

    protected Object source() {
        return this;
    }

    @Override
    public Map<String, List<Manageable>> getManageableChildren() {
        return U.map();
    }

    protected Object doManageableAction(String action) {
        throw U.rte((String)"Cannot handle action '%s'!", (Object[])new Object[]{action});
    }

    @Override
    public GroupOf<? extends Manageable> group() {
        return null;
    }

    @Override
    public String kind() {
        return Manageables.kindOf(this.source().getClass());
    }

    protected void doReloadManageable(Callback<Void> callback) {
        Callbacks.done(callback, null, null);
    }

    @Override
    public final void reloadManageable() {
        Promise<Void> promise = Promises.create();
        this.doReloadManageable(promise);
        try {
            promise.get(5000L);
        }
        catch (TimeoutException e) {
            Log.error((String)"Couldn't reload the manageable!", (Throwable)e);
        }
    }

    @Override
    public Object getManageableDisplay() {
        return null;
    }
}

