/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.group;

import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.group.GroupOf;
import org.rapidoid.group.Groups;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.u.U;

public class Manageables
extends RapidoidThing {
    public static String kindOf(Class<?> cls) {
        ManageableBean mb = cls.getAnnotation(ManageableBean.class);
        U.must((mb != null ? 1 : 0) != 0, (String)"The type '%s' must be annotated with @%s", (Object)ManageableBean.class.getSimpleName());
        return mb.kind();
    }

    public static <T extends Manageable> T find(Class<? extends T> itemType, String id) {
        for (GroupOf<T> group : Groups.find(itemType)) {
            T member = group.find(id);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    public static Manageable find(String itemType, String id) {
        for (GroupOf group : Groups.find(itemType)) {
            Object member = group.find(id);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    public static Manageable find(String kind, String id, String sub) {
        Manageable target = Manageables.find(kind, id);
        U.must((target != null ? 1 : 0) != 0, (String)"Cannot find the manageable!");
        target.reloadManageable();
        if (U.isEmpty((String)sub)) {
            return target;
        }
        return Manageables.findSub(target, sub);
    }

    private static Manageable findSub(Manageable target, String sub) {
        String[] parts = sub.split("/", 3);
        String seg = parts[0];
        String id = parts[1];
        List<Manageable> segment = target.getManageableChildren().get(seg);
        U.must((segment != null ? 1 : 0) != 0, (String)"Cannot find the manageable segment: %s", (Object)seg);
        target = Manageables.findById(segment, id);
        U.must((target != null ? 1 : 0) != 0, (String)"Cannot find the sub-manageable with id: %s in segment: %s", (Object)id, (Object)seg);
        target.reloadManageable();
        return parts.length > 2 ? Manageables.findSub(target, parts[2]) : target;
    }

    private static Manageable findById(List<? extends Manageable> items, String id) {
        U.notNull((Object)id, (String)"id", (Object[])new Object[0]);
        for (Manageable manageable : items) {
            if (!U.eq((Object)id, (Object)manageable.id())) continue;
            return manageable;
        }
        return null;
    }
}

