/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.job.Jobs;
import org.rapidoid.job.ManageableExecutor;

public class JobExecutor
extends RapidoidThing
implements Closeable {
    private static final Config CONFIG = Conf.JOBS.sub("executor");
    private final ThreadPoolExecutor executor = JobExecutor.newExecutor();

    public JobExecutor() {
        new ManageableExecutor("executor", this.executor);
        Jobs.init();
    }

    private static ThreadPoolExecutor newExecutor() {
        int threads = CONFIG.entry("threads").or(64);
        int maxThreads = CONFIG.entry("maxThreads").or(1024);
        int maxQueueSize = CONFIG.entry("maxQueueSize").or(1000000);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(maxQueueSize);
        return new ThreadPoolExecutor(threads, maxThreads, 300L, TimeUnit.SECONDS, queue, new RapidoidThreadFactory("executor", true));
    }

    @Override
    public void close() {
        this.executor.shutdown();
        Jobs.awaitTermination(this.executor);
    }

    public ThreadPoolExecutor executor() {
        return this.executor;
    }
}

