/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.io.Closeable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.job.Jobs;
import org.rapidoid.job.ManageableExecutor;

public class JobScheduler
extends RapidoidThing
implements Closeable {
    private static final Config CONFIG = Conf.JOBS.sub("scheduler");
    private final ScheduledThreadPoolExecutor scheduler = JobScheduler.newScheduler();

    public JobScheduler() {
        new ManageableExecutor("scheduler", this.scheduler);
        Jobs.init();
    }

    private static ScheduledThreadPoolExecutor newScheduler() {
        int threads = CONFIG.entry("threads").or(64);
        return new ScheduledThreadPoolExecutor(threads, new RapidoidThreadFactory("scheduler", true));
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
        Jobs.awaitTermination(this.scheduler);
    }

    public ScheduledThreadPoolExecutor scheduler() {
        return this.scheduler;
    }
}

