/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Str;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.scan.ScanParams;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ClasspathScanner
extends RapidoidThing {
    private static Map<ScanParams, List<String>> cache = Coll.autoExpandingMap(new Mapper<ScanParams, List<String>>(){

        @Override
        public List<String> map(ScanParams params) throws Exception {
            return ClasspathScanner.scanClasses(params);
        }
    });

    public static synchronized void reset() {
        cache.clear();
    }

    public static List<String> scan(ScanParams params) {
        return ClasspathScanner.scanClasses(params);
    }

    private static List<String> scanClasses(ScanParams params) {
        Pattern pattern;
        Object[] pkgs = params.in();
        String rootPackage = ClasspathUtil.getRootPackage();
        if (U.isEmpty((Object[])pkgs)) {
            String[] stringArray;
            if (rootPackage != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = rootPackage;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            pkgs = stringArray;
        }
        long startingAt = U.time();
        String regex = params.matching();
        Pattern pattern2 = pattern = U.notEmpty((String)regex) ? Pattern.compile(regex) : null;
        if (regex != null) {
            Log.info((String)"Scanning classpath", (String)"!annotated", (Object)Msc.annotations(params.annotated()), (String)"!packages", (Object)Arrays.toString(pkgs), (String)"!matching", (Object)regex);
        } else {
            Log.info((String)"Scanning classpath", (String)"!annotated", (Object)Msc.annotations(params.annotated()), (String)"!packages", (Object)Arrays.toString(pkgs));
        }
        Set classpath = U.notEmpty((Object[])params.classpath()) ? U.set((Object[])params.classpath()) : ClasspathUtil.getClasspath();
        AtomicInteger searched = new AtomicInteger();
        Set classes = U.set();
        for (Object pkg : pkgs) {
            classes.addAll(ClasspathScanner.retrieveClasses(classpath, (String)pkg, params.annotated(), params.bytecodeFilter(), pattern, params.classLoader(), searched));
        }
        List classList = U.list((Iterable)classes);
        long timeMs = U.time() - startingAt;
        Log.info((String)"Finished classpath scan", (String)"time", (Object)(Msc.maybeMasked(timeMs) + "ms"), (String)"searched", (Object)searched.get(), (String)"!found", (Object)Msc.classNames(classList));
        return classList;
    }

    private static List<String> retrieveClasses(Set<String> classpath, String packageName, Class<? extends Annotation>[] annotated, Predicate<InputStream> bytecodeFilter, Pattern regex, ClassLoader classLoader, AtomicInteger searched) {
        List classes = U.list();
        String pkgName = U.safe((String)packageName);
        String pkgPath = pkgName.replace('.', File.separatorChar);
        Log.trace((String)"Starting classpath scan", (String)"package", (Object)packageName, (String)"annotated", annotated, (String)"regex", (Object)regex, (String)"loader", (Object)classLoader);
        Log.trace((String)"Classpath details", (String)"classpath", classpath);
        Set jars = U.set();
        for (String cpe : classpath) {
            File cpEntry = new File(cpe);
            if (cpEntry.exists()) {
                if (cpEntry.isDirectory()) {
                    if (ClasspathScanner.shouldScanDir(cpEntry.getAbsolutePath())) {
                        Log.trace((String)"Scanning directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                        File startingDir = pkgPath.isEmpty() ? cpEntry : new File(cpEntry.getAbsolutePath(), pkgPath);
                        if (!startingDir.exists()) continue;
                        ClasspathScanner.getClassesFromDir(classes, cpEntry, startingDir, pkgName, regex, annotated, bytecodeFilter, searched);
                        continue;
                    }
                    Log.trace((String)"Skipping directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                    continue;
                }
                if (cpEntry.isFile() && cpEntry.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                    jars.add(cpEntry.getAbsolutePath());
                    continue;
                }
                Log.warn((String)("Invalid classpath entry: " + cpe));
                continue;
            }
            if (cpe.contains("*") || cpe.contains("?") || !U.neq((Object)cpe, (Object)ClasspathUtil.appJar())) continue;
            Log.warn((String)("Classpath entry doesn't exist: " + cpe));
        }
        for (String jarName : jars) {
            if (ClasspathScanner.shouldScanJAR(jarName)) {
                Log.trace((String)"Scanning JAR", (String)"name", (Object)jarName);
                ClasspathScanner.getClassesFromJAR(jarName, classes, packageName, regex, annotated, bytecodeFilter, classLoader, searched);
                continue;
            }
            Log.trace((String)"Skipping JAR", (String)"name", (Object)jarName);
        }
        return classes;
    }

    private static boolean shouldScanDir(String dir) {
        return true;
    }

    private static boolean shouldScanJAR(String jar) {
        String filename = new File(jar).getName();
        return !filename.equalsIgnoreCase("rapidoid.jar") && (!ClasspathUtil.hasAppJar() || U.eq((Object)jar, (Object)ClasspathUtil.appJar()));
    }

    private static void getClassesFromDir(Collection<String> classes, File root, File dir, String pkg, Pattern regex, Class<? extends Annotation>[] annotated, Predicate<InputStream> bytecodeFilter, AtomicInteger searched) {
        U.must((boolean)dir.isDirectory());
        Log.trace((String)"Traversing directory", (String)"root", (Object)root, (String)"dir", (Object)dir);
        File[] files = dir.listFiles();
        if (files == null) {
            Log.warn((String)"Not a folder!", (String)"dir", (Object)dir);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClasspathScanner.getClassesFromDir(classes, root, file, pkg, regex, annotated, bytecodeFilter, searched);
                continue;
            }
            String rootPath = Str.trimr(root.getAbsolutePath(), File.separatorChar);
            int from = rootPath.length() + 1;
            String relName = file.getAbsolutePath().substring(from);
            if (ClasspathScanner.ignore(relName)) continue;
            ClasspathScanner.scanFile(classes, regex, annotated, bytecodeFilter, relName, file, null, null, searched);
        }
    }

    private static void scanFile(Collection<String> classes, Pattern regex, Class<? extends Annotation>[] annotated, Predicate<InputStream> bytecodeFilter, String relName, File file, ZipFile zip, ZipEntry entry, AtomicInteger searched) {
        Log.trace((String)"scanned file", (String)"file", (Object)relName);
        if (relName.endsWith(".class")) {
            searched.incrementAndGet();
            String clsName = Str.sub(relName, 0, -6).replace('/', '.').replace('\\', '.');
            if (U.isEmpty((Object)regex) || regex.matcher(clsName).matches()) {
                try {
                    boolean include;
                    InputStream input;
                    InputStream inputStream = input = file != null ? new FileInputStream(file) : zip.getInputStream(entry);
                    if (U.isEmpty((Object[])annotated)) {
                        include = true;
                    } else {
                        ClassFile classFile = new ClassFile(new DataInputStream(input));
                        include = ClasspathScanner.isAnnotated(classFile, annotated);
                    }
                    if (include && bytecodeFilter != null) {
                        include = Lmbd.eval(bytecodeFilter, input);
                    }
                    if (include) {
                        classes.add(clsName);
                    }
                }
                catch (Throwable e) {
                    Log.debug((String)"Error while loading class", (String)"name", (Object)clsName, (String)"error", (Object)e);
                }
            }
        }
    }

    private static boolean isAnnotated(ClassFile cfile, Class<? extends Annotation>[] annotated) throws IOException {
        List attributes = U.safe((List)cfile.getAttributes());
        for (Object attribute : attributes) {
            if (!(attribute instanceof AnnotationsAttribute)) continue;
            AnnotationsAttribute annotations = (AnnotationsAttribute)attribute;
            for (Class<? extends Annotation> ann : annotated) {
                if (annotations.getAnnotation(ann.getName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getClassesFromJAR(String jarName, List<String> classes, String pkg, Pattern regex, Class<? extends Annotation>[] annotated, Predicate<InputStream> bytecodeFilter, ClassLoader classLoader, AtomicInteger searched) {
        ZipFile zip = null;
        try {
            String pkgPath = pkg != null ? pkg.replace('.', File.separatorChar) : null;
            String pkgPath2 = pkg != null ? pkg.replace('.', '/') : null;
            zip = new ZipFile(new File(jarName));
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || ClasspathScanner.ignore(name = zipEntry.getName()) || !U.isEmpty((String)pkg) && !name.startsWith(pkgPath) && !name.startsWith(pkgPath2)) continue;
                ClasspathScanner.scanFile(classes, regex, annotated, bytecodeFilter, name, null, zip, zipEntry, searched);
            }
        }
        catch (Exception e) {
            Log.error((String)("Cannot scan JAR: " + jarName), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    Log.error((String)"Couldn't close the ZIP stream!", (Throwable)e);
                }
            }
        }
        return classes;
    }

    private static boolean ignore(String name) {
        String part2;
        String pkgDirName = Str.triml(name, File.separatorChar);
        int p1 = pkgDirName.indexOf(File.separatorChar);
        int p2 = -1;
        return p1 > 0 && (p2 = pkgDirName.indexOf(File.separatorChar, p1 + 1)) > 0 && U.isEmpty((String)(part2 = pkgDirName.substring(p1 + 1, p2)));
    }
}

