/*-
 * #%L
 * rapidoid-commons
 * %%
 * Copyright (C) 2014 - 2018 Nikolche Mihajlovski and contributors
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package org.rapidoid.value;

import org.rapidoid.annotation.Authors;
import org.rapidoid.annotation.Since;


@Authors("Nikolche Mihajlovski")
@Since("5.1.0")
public abstract class AbstractDecoratorValue<SRC, T> extends AbstractValue<T> {

	protected final Value<SRC> src;

	public AbstractDecoratorValue(Value<SRC> src) {
		this.src = src;
	}

	@Override
	public String desc() {
		return src.desc();
	}

}
