/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.util.Iterator;
import java.util.List;
import org.rapidoid.collection.Coll;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.Pager;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.TdTag;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.Models;
import org.rapidoid.model.Property;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.var.Var;
import org.rapidoid.wrap.BoolWrap;

public class Grid
extends AbstractWidget<Grid> {
    private volatile Iterable<?> items;
    private volatile String orderBy;
    private volatile int pageSize = 10;
    private volatile String[] columns = new String[0];
    private volatile Object[] headers = new Object[0];
    private volatile String rowCmd;
    private volatile String highlightRegex;
    private volatile Mapper<Object, String> toUri;

    @Override
    protected Object render() {
        List rows;
        Pager pager = this.noPager();
        boolean paging = this.pageSize > 0;
        BoolWrap isLastPage = new BoolWrap();
        if (paging) {
            String pageParam = "_p" + this.seq("pager");
            pager = GUI.pager(pageParam).min(1);
            Integer size = Coll.getSizeOrNull(this.items);
            if (size != null) {
                int pages = (int)Math.ceil((double)size.intValue() / (double)this.pageSize);
                pager.max(pages);
            }
            rows = Msc.getPage(this.items, (int)pager.pageNumber(), (int)this.pageSize, (Integer)size, (BoolWrap)isLastPage);
        } else {
            rows = this.items;
        }
        return this.renderGridPage(pager, rows, isLastPage.value);
    }

    private Object renderGridPage(Pager pager, Iterable<?> rows, boolean isLastPage) {
        Iterator<?> it = rows.iterator();
        boolean hasData = it.hasNext();
        if (pager != null && (isLastPage || !hasData)) {
            pager.max(pager.pageNumber());
        }
        if (!hasData) {
            return U.list((Object[])new Object[]{this.noDataAvailable(), pager});
        }
        Class<?> type = it.next().getClass();
        Items itemsModel = rows instanceof Items ? (Items)rows : Models.beanItems(type, U.array(rows));
        List<Property> props = itemsModel.properties(this.columns);
        boolean ordered = !U.isEmpty((String)this.orderBy);
        Var<String> order = null;
        String currentOrder = this.orderBy;
        if (ordered) {
            order = GUI.var("_o" + this.seq("order"), this.orderBy);
            currentOrder = (String)order.get();
            itemsModel = itemsModel.orderedBy(currentOrder);
        }
        Tag header = this.tableHeader(props, order);
        Tag body = this.tableBody(props, itemsModel);
        return this.fullTable(header, body, pager);
    }

    protected Tag noDataAvailable() {
        return GUI.NOTHING;
    }

    protected Pager noPager() {
        return null;
    }

    protected Tag fullTable(Tag header, Tag body, Pager pager) {
        return GUI.row(GUI.table_(GUI.thead(header), body), pager);
    }

    protected Tag tableBody(List<Property> props, Items pageOrAll) {
        Tag body = GUI.tbody(new Object[0]);
        for (Item item : pageOrAll) {
            Tag row = this.itemRow(props, item);
            body = body.append(row);
        }
        return body;
    }

    protected Tag tableHeader(List<Property> props, Var<String> order) {
        Tag header = Grid.tr(new Object[0]);
        for (int i = 0; i < props.size(); ++i) {
            Object sort;
            Property prop = props.get(i);
            Tag sortIcon = null;
            Object caption = U.notEmpty((Object[])this.headers) && this.headers.length > i ? this.headers[i] : null;
            caption = U.or(caption, (Object)prop.caption());
            if (order != null) {
                String currentOrder = (String)order.get();
                if (currentOrder.equals(prop.name())) {
                    sortIcon = GUI.fa("sort-amount-asc");
                }
                if (currentOrder.equals("-" + prop.name())) {
                    sortIcon = GUI.fa("sort-amount-desc");
                }
                sort = GUI.a_void(caption, " ", sortIcon).cmd("_sort", order, prop.name());
            } else {
                sort = caption;
            }
            header = header.append(Grid.th(sort));
        }
        return header;
    }

    protected Tag itemRow(List<Property> properties, Item item) {
        Tag row = Grid.tr(new Object[0]);
        for (Property prop : properties) {
            Object value = prop.get(item);
            value = U.or((Object)value, (Object)"");
            row = row.append(this.cell(GUI.display(value)));
        }
        if (this.rowCmd != null) {
            row = row.cmd(this.rowCmd, item.value());
            row = row.class_("pointer");
        } else {
            String js = this.onClickScript(item);
            if (U.notEmpty((String)js)) {
                row = row.onclick(js);
                row = row.class_("pointer");
            }
        }
        return row;
    }

    protected String onClickScript(Item item) {
        String uri;
        if (this.toUri != null) {
            uri = (String)Lmbd.eval(this.toUri, (Object)item.value());
        } else {
            uri = GUI.uriFor(item.value());
            if (U.notEmpty((String)uri)) {
                uri = Msc.uri((String[])new String[]{uri, "view"});
            }
        }
        return U.notEmpty((String)uri) ? U.frmt((String)"Rapidoid.goAt('%s');", (Object[])new Object[]{uri}) : null;
    }

    protected TdTag cell(Object value) {
        if (U.notEmpty((String)this.highlightRegex)) {
            String s = String.valueOf(value);
            value = GUI.highlight(s, this.highlightRegex);
        }
        return Grid.td(value);
    }

    public Iterable<?> items() {
        return this.items;
    }

    public Grid items(Iterable<?> items) {
        U.must((!(items instanceof Items) ? 1 : 0) != 0);
        this.items = items;
        return this;
    }

    public String orderBy() {
        return this.orderBy;
    }

    public Grid orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Grid pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String[] columns() {
        return this.columns;
    }

    public Grid columns(String ... columns) {
        this.columns = columns;
        return this;
    }

    public Grid columns(Iterable<String> columns) {
        return this.columns((String[])U.arrayOf(String.class, columns));
    }

    public String rowCmd() {
        return this.rowCmd;
    }

    public Grid rowCmd(String rowCmd) {
        this.rowCmd = rowCmd;
        return this;
    }

    public Mapper<Object, String> toUri() {
        return this.toUri;
    }

    public <T> Grid toUri(Mapper<T, String> toUri) {
        this.toUri = toUri;
        return this;
    }

    public Object[] headers() {
        return this.headers;
    }

    public Grid headers(Object ... headers) {
        this.headers = headers;
        return this;
    }

    public Grid headers(Iterable<?> headers) {
        return this.headers(U.array(headers));
    }

    public String highlightRegex() {
        return this.highlightRegex;
    }

    public Grid highlightRegex(String highlightRegex) {
        this.highlightRegex = highlightRegex;
        return this;
    }
}

