/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.commons.RapidoidInfo;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.HtmlPageUtils;
import org.rapidoid.gui.menu.PageMenu;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.gui.reqinfo.ReqInfo;
import org.rapidoid.gui.reqinfo.ReqInfoUtils;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.render.Template;
import org.rapidoid.render.Templates;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.web.ScreenBean;
import org.rapidoid.writable.Writable;
import org.rapidoid.writable.WritableOutputStream;
import org.rapidoid.writable.WritableUtils;

public class HtmlPage
extends ScreenBean {
    private static volatile String commonJs = Msc.isPlatform() ? "_rapidoid/platform.js" : "application.js";
    private static volatile String commonCss = Msc.isPlatform() ? "_rapidoid/platform.css" : "application.css";
    private static volatile Template PAGE_TEMPLATE = Templates.load((String)"page.html");
    private static volatile Template PAGE_AJAX_TEMPLATE = Templates.load((String)"page-ajax.html");

    public HtmlPage(Object[] content) {
        this.content(content);
    }

    public String render() {
        IReqInfo req;
        Map<String, Object> model = this.pageModel();
        if (this.menu() != null) {
            PageMenu.from(this.menu()).renderContentTemplates(model);
        }
        String html = (req = ReqInfo.get()).isGetReq() && !GUI.isEvent() ? PAGE_TEMPLATE.render(model) : PAGE_AJAX_TEMPLATE.render(model);
        return html;
    }

    public void render(OutputStream out) {
        String html = this.render();
        WritableUtils.writeUTF8((Writable)new WritableOutputStream(out), (String)html);
    }

    private Map<String, Object> pageModel() {
        IReqInfo req = ReqInfo.get();
        Map model = U.map(req.data());
        model.put("req", req);
        model.put("appUrl", ReqInfoUtils.appUrl());
        model.put("adminUrl", ReqInfoUtils.adminUrl());
        model.put("loginUri", Msc.specialUri((String[])new String[]{"login"}));
        model.put("logoutUri", Msc.specialUri((String[])new String[]{"logout"}));
        model.put("profileUri", Msc.semiSpecialUri((String[])new String[]{"profile"}));
        model.put("graphsUri", Msc.specialUri((String[])new String[]{"graphs"}));
        model.put("dev", Msc.isDev());
        model.put("admin", "admin".equalsIgnoreCase(req.zone()));
        model.put("host", req.host());
        model.put("verb", req.verb());
        model.put("uri", req.uri());
        model.put("path", req.path());
        model.put("zone", req.zone());
        model.put("username", req.username());
        Set<String> roles = req.roles();
        model.put("roles", roles);
        model.put("has", this.has());
        model.put("content", GUI.multi(this.content()));
        model.put("home", req.contextPath() + this.home());
        model.put("brand", this.brand());
        model.put("title", this.title());
        PageMenu pageMenu = PageMenu.from(this.menu());
        pageMenu.uri(req.path());
        model.put("menu", pageMenu);
        model.put("version", RapidoidInfo.version());
        model.put("embedded", this.embedded() || req.attrs().get("_embedded") != null || req.params().get("_embedded") != null);
        model.put("search", this.search());
        model.put("navbar", this.navbar());
        model.put("fluid", this.fluid());
        model.put("cdn", this.cdn());
        List assets = (List)Conf.GUI.entry("assets").getOrNull();
        if (U.notEmpty((Collection)assets)) {
            for (String asset : assets) {
                String res = asset.toLowerCase();
                if (res.endsWith(".js")) {
                    this.js().add(res);
                    continue;
                }
                if (res.endsWith(".css")) {
                    this.css().add(res);
                    continue;
                }
                throw U.rte((String)("Expected .css or .js asset, but found: " + res));
            }
        }
        this.setupAssets(req, model);
        return model;
    }

    private void setupAssets(IReqInfo req, Map<String, Object> model) {
        String view = req.view();
        if (req.hasRoute(HttpVerb.GET, commonJs)) {
            this.js().add(commonJs);
        }
        if (req.hasRoute(HttpVerb.GET, commonCss)) {
            this.css().add(commonCss);
        }
        if (U.notEmpty((String)view)) {
            String pageCss;
            String pageJs = "/" + view + ".js";
            if (req.hasRoute(HttpVerb.GET, pageJs)) {
                this.js().add(pageJs);
            }
            if (req.hasRoute(HttpVerb.GET, pageCss = "/" + view + ".css")) {
                this.css().add(pageCss);
            }
        }
        model.put("js", HtmlPage.withContextPath(this.js(), req.contextPath()));
        model.put("css", HtmlPage.withContextPath(this.css(), req.contextPath()));
    }

    private static Set<String> withContextPath(Set<String> assets, String contextPath) {
        Set withContextPath = U.set();
        for (String asset : assets) {
            if (!(asset.startsWith("http://") || asset.startsWith("https://") || asset.startsWith("//"))) {
                asset = contextPath + "/" + Str.triml((String)asset, (String)"/");
            }
            withContextPath.add(asset);
        }
        return withContextPath;
    }

    private Map<String, Object> has() {
        Map has = U.map();
        has.put("role", HtmlPageUtils.HAS_ROLE);
        has.put("path", HtmlPageUtils.HAS_PATH);
        has.put("zone", HtmlPageUtils.HAS_ZONE);
        has.put("page", HtmlPageUtils.HAS_PAGE);
        has.put("special_page", HtmlPageUtils.HAS_SPECIAL_PAGE);
        return has;
    }

    public static String commonJs() {
        return commonJs;
    }

    public static void commonJs(String commonJs) {
        HtmlPage.commonJs = commonJs;
    }

    public static String commonCss() {
        return commonCss;
    }

    public static void commonCss(String commonCss) {
        HtmlPage.commonCss = commonCss;
    }

    public String toString() {
        return this.render();
    }
}

